/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.annotations.AnnotationManager;
import org.datanucleus.metadata.annotations.AnnotationReader;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class AnnotationManagerImpl
implements AnnotationManager {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.metadata.annotations.Localisation", (ClassLoader)AnnotationReader.class.getClassLoader());
    protected final MetaDataManager metadataMgr;
    Map<String, String> annotationReaderLookup = new HashMap<String, String>();
    Map<String, AnnotationReader> annotationReaders = new HashMap<String, AnnotationReader>();

    public AnnotationManagerImpl(MetaDataManager metadataMgr) {
        this.metadataMgr = metadataMgr;
        Extension[] ex = this.metadataMgr.getOMFContext().getPluginManager().getExtensionPoint("org.datanucleus.java5.annotations").getExtensions();
        for (int i = 0; i < ex.length; ++i) {
            ConfigurationElement[] confElm = ex[i].getConfigurationElements();
            for (int j = 0; j < confElm.length; ++j) {
                this.annotationReaderLookup.put(confElm[j].getAttribute("annotation-class"), confElm[j].getAttribute("reader"));
            }
        }
    }

    public AbstractClassMetaData getMetaDataForClass(Class cls, PackageMetaData pmd, ClassLoaderResolver clr) {
        if (cls == null) {
            return null;
        }
        Annotation[] annotations = cls.getAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        String readerClassName = null;
        for (int i = 0; i < annotations.length; ++i) {
            String reader = this.annotationReaderLookup.get(annotations[i].annotationType().getName());
            if (reader == null) continue;
            readerClassName = reader;
            break;
        }
        if (readerClassName == null) {
            NucleusLogger.METADATA.warn((Object)LOCALISER.msg("MetaData.Annotations.NoReaderForClass", (Object)cls.getName()));
            return null;
        }
        AnnotationReader reader = this.annotationReaders.get(readerClassName);
        if (reader == null) {
            try {
                Class annotationReaderClass = clr.classForName(readerClassName, ObjectManagerFactoryImpl.class.getClassLoader());
                Class[] ctrArgs = new Class[]{MetaDataManager.class};
                Object[] ctrParams = new Object[]{this.metadataMgr};
                Constructor ctor = annotationReaderClass.getConstructor(ctrArgs);
                reader = (AnnotationReader)ctor.newInstance(ctrParams);
                this.annotationReaders.put(readerClassName, reader);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.warn((Object)LOCALISER.msg("MetaData.AnnotationReaderNotFound", (Object)readerClassName));
                return null;
            }
        }
        return reader.getMetaDataForClass(cls, pmd, clr);
    }
}

