/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.java8.converters;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateTimeTimestampConverter
implements TypeConverter<LocalDateTime, Timestamp> {
    private static final long serialVersionUID = -4426520457647540543L;

    public LocalDateTime toMemberType(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(ts);
        return LocalDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000);
    }

    public Timestamp toDatastoreType(LocalDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(datetime.getYear(), datetime.getMonth().ordinal(), datetime.getDayOfMonth(), datetime.getHour(), datetime.getMinute(), datetime.getSecond());
        return new Timestamp(cal.getTimeInMillis());
    }
}

