/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.java8.converters;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Calendar;
import org.datanucleus.store.types.converters.TypeConverter;

public class OffsetDateTimeTimestampConverter
implements TypeConverter<OffsetDateTime, Timestamp> {
    private static final long serialVersionUID = 1020419574496380608L;

    public OffsetDateTime toMemberType(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(ts);
        return OffsetDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000, null);
    }

    public Timestamp toDatastoreType(OffsetDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(datetime.getYear(), datetime.getMonth().ordinal(), datetime.getDayOfMonth(), datetime.getHour(), datetime.getMinute(), datetime.getSecond());
        return new Timestamp(cal.getTimeInMillis());
    }
}

