/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.java8.converters;

import java.sql.Time;
import java.time.OffsetTime;
import java.util.Calendar;
import org.datanucleus.store.types.converters.TypeConverter;

public class OffsetTimeSqlTimeConverter
implements TypeConverter<OffsetTime, Time> {
    private static final long serialVersionUID = 3340435954686655963L;

    public OffsetTime toMemberType(Time time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return OffsetTime.of(cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000, null);
    }

    public Time toDatastoreType(OffsetTime time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(0, 0, 0, time.getHour(), time.getMinute(), time.getSecond());
        cal.set(14, time.getNano() / 1000000);
        return new Time(cal.getTimeInMillis());
    }
}

