/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Date;
import javax.time.calendar.LocalDateTime;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.JavaxTimeLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.types.LocalDateStringConverter;

public class LocalDateTimeLiteral
extends JavaxTimeLiteral {
    private final LocalDateTime value;

    public LocalDateTimeLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, mapping, parameterName);
        if (value == null) {
            this.value = null;
        } else if (value instanceof LocalDateTime) {
            this.value = (LocalDateTime)value;
        } else {
            throw new NucleusException("Cannot create " + ((Object)((Object)this)).getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String str = new LocalDateStringConverter().toString(value);
            this.delegate = new StringLiteral(stmt, mapping, (Object)(this.value != null ? str : null), parameterName);
        } else if (this.value == null) {
            this.delegate = new TemporalLiteral(stmt, mapping, null, parameterName);
        } else {
            LocalDateTime localDate = (LocalDateTime)value;
            Date date = new Date();
            date.setYear(localDate.getYear());
            date.setMonth(localDate.getMonthOfYear().ordinal());
            date.setDate(localDate.getDayOfMonth());
            date.setHours(localDate.getHourOfDay());
            date.setMinutes(localDate.getMinuteOfHour());
            date.setSeconds(localDate.getSecondOfMinute());
            this.delegate = new TemporalLiteral(stmt, mapping, (Object)date, parameterName);
        }
    }

    public Object getValue() {
        return this.value;
    }
}

