/**********************************************************************
Copyright (c) 2010 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.types;

import javax.time.calendar.LocalDate;

import org.datanucleus.store.types.ObjectStringConverter;

/**
 * Class to handle the conversion between javax.time.calendar.LocalDate and a String form.
 * The string form is ISO8601 format ("yyyy-MM-dd").
 */
public class LocalDateStringConverter implements ObjectStringConverter<LocalDate>
{
    /* (non-Javadoc)
     * @see org.datanucleus.store.types.ObjectStringConverter#toObject(java.lang.String)
     */
    public LocalDate toObject(String str)
    {
        if (str == null)
        {
            return null;
        }

        return LocalDate.parse(str);
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.types.ObjectStringConverter#toString(javax.time.calendar.LocalDate)
     */
    public String toString(LocalDate ld)
    {
        return ld != null ? ld.toString() : null;
    }
}