/*
 * Decompiled with CFR 0.152.
 */
package org.dependencytrack.api.parsers;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import org.dependencytrack.api.model.Analysis;
import org.dependencytrack.api.model.Component;
import org.dependencytrack.api.model.Finding;
import org.dependencytrack.api.model.Meta;
import org.dependencytrack.api.model.Project;
import org.dependencytrack.api.model.Severity;
import org.dependencytrack.api.model.Vulnerability;

public class FindingParser {
    private JsonReader jsonReader;
    private String version;
    private Meta meta;
    private Project project;
    private ArrayList<Finding> findings;
    private Format format;

    protected FindingParser() {
    }

    public FindingParser(String jsonString) {
        this.jsonReader = Json.createReader((Reader)new StringReader(jsonString));
    }

    public FindingParser(InputStream jsonResponseInputStream) {
        this.jsonReader = Json.createReader((InputStream)jsonResponseInputStream);
    }

    public FindingParser parse() {
        JsonStructure structure = this.jsonReader.read();
        if (structure instanceof JsonArray) {
            this.format = Format.FINDING_API;
            this.findings = this.parseFindings((JsonArray)structure);
        } else if (structure instanceof JsonObject) {
            this.format = Format.FINDING_PACKAGING_FORMAT;
            JsonObject root = (JsonObject)structure;
            this.version = FindingParser.trimToNull(root.getString("version", null));
            this.meta = this.parseMeta(root.getJsonObject("meta"));
            this.project = this.parseProject(root.getJsonObject("project"));
            this.findings = this.parseFindings(root.getJsonArray("findings"));
        }
        return this;
    }

    private ArrayList<Finding> parseFindings(JsonArray json) {
        ArrayList<Finding> findings = new ArrayList<Finding>();
        for (int i = 0; i < json.size(); ++i) {
            Finding finding = this.parseFinding(json.getJsonObject(i));
            if (finding.getAnalysis().isSuppressed()) continue;
            findings.add(finding);
        }
        return findings;
    }

    private Finding parseFinding(JsonObject json) {
        Project project = this.parseProject(json.getJsonObject("project"));
        Component component = this.parseComponent(json.getJsonObject("component"));
        Vulnerability vulnerability = this.parseVulnerability(json.getJsonObject("vulnerability"));
        Analysis analysis = this.parseAnalysis(json.getJsonObject("analysis"));
        String matrix = FindingParser.trimToNull(json.getString("matrix"));
        return new Finding(component, vulnerability, analysis, matrix);
    }

    private Component parseComponent(JsonObject json) {
        String uuid = FindingParser.trimToNull(json.getString("uuid"));
        String name = FindingParser.trimToNull(json.getString("name"));
        String group = FindingParser.trimToNull(json.getString("group", null));
        String version = FindingParser.trimToNull(json.getString("version", null));
        String purl = FindingParser.trimToNull(json.getString("purl", null));
        return new Component(uuid, name, group, version, purl);
    }

    private Vulnerability parseVulnerability(JsonObject json) {
        String uuid = FindingParser.trimToNull(json.getString("uuid"));
        String source = FindingParser.trimToNull(json.getString("source"));
        String vulnId = FindingParser.trimToNull(json.getString("vulnId", null));
        String title = FindingParser.trimToNull(json.getString("title", null));
        String subtitle = FindingParser.trimToNull(json.getString("subtitle", null));
        String description = FindingParser.trimToNull(json.getString("description", null));
        String recommendation = FindingParser.trimToNull(json.getString("recommendation", null));
        Severity severity = Severity.valueOf(json.getString("severity", null));
        Integer severityRank = json.getInt("severityRank", -1);
        Integer cweId = json.getInt("cweId", -1);
        String cweName = FindingParser.trimToNull(json.getString("cweName", null));
        return new Vulnerability(uuid, source, vulnId, title, subtitle, description, recommendation, severity, severityRank, cweId, cweName);
    }

    private Analysis parseAnalysis(JsonObject json) {
        String state = FindingParser.trimToNull(json.getString("state", null));
        boolean isSuppressed = json.getBoolean("isSuppressed", false);
        return new Analysis(state, isSuppressed);
    }

    private Project parseProject(JsonObject json) {
        if (json == null) {
            return null;
        }
        String uuid = FindingParser.trimToNull(json.getString("uuid", null));
        String name = FindingParser.trimToNull(json.getString("name", null));
        String version = FindingParser.trimToNull(json.getString("version", null));
        String description = FindingParser.trimToNull(json.getString("description", null));
        String purl = FindingParser.trimToNull(json.getString("purl", null));
        return new Project(uuid, name, version, description, purl);
    }

    private Meta parseMeta(JsonObject json) {
        if (json == null) {
            return null;
        }
        String application = FindingParser.trimToNull(json.getString("application", null));
        String version = FindingParser.trimToNull(json.getString("version", null));
        String timestamp = FindingParser.trimToNull(json.getString("timestamp", null));
        String baseUrl = FindingParser.trimToNull(json.getString("baseUrl", null));
        return new Meta(application, version, timestamp, baseUrl);
    }

    public ArrayList<Finding> getFindings() {
        return this.findings;
    }

    public String getVersion() {
        return this.version;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Project getProject() {
        return this.project;
    }

    public Format getFormat() {
        return this.format;
    }

    private static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String trimmed = string.trim();
        return trimmed.length() == 0 ? null : trimmed;
    }

    public static enum Format {
        FINDING_API,
        FINDING_PACKAGING_FORMAT;

    }
}

