/*
 * Decompiled with CFR 0.152.
 */
package org.dependencytrack.api.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    private static final String ZULU = "UTC";
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    private DateUtil() {
    }

    public static String toISO8601(Date date) {
        TimeZone tz = TimeZone.getTimeZone(ZULU);
        SimpleDateFormat df = new SimpleDateFormat(ISO_8601_FORMAT);
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static Date fromISO8601(String date) throws ParseException {
        TimeZone tz = TimeZone.getTimeZone(ZULU);
        SimpleDateFormat df = new SimpleDateFormat(ISO_8601_FORMAT);
        df.setTimeZone(tz);
        return df.parse(date);
    }
}

