/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.auth.basic;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.edc.api.auth.basic.BasicAuthenticationService;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;

@Provides(value={AuthenticationService.class})
@Extension(value="Basic authentication")
public class BasicAuthenticationExtension
implements ServiceExtension {
    @Setting
    public static final String BASIC_AUTH = "edc.api.auth.basic.vault-keys";
    @Inject
    private Vault vault;

    public void initialize(ServiceExtensionContext context) {
        Monitor monitor = context.getMonitor();
        List<ConfigCredentials> credentials = context.getConfig(BASIC_AUTH).getRelativeEntries().entrySet().stream().map(entry -> new ConfigCredentials((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        if (!credentials.isEmpty()) {
            BasicAuthenticationService authService = new BasicAuthenticationService(this.vault, credentials, monitor);
            context.registerService(AuthenticationService.class, (Object)authService);
            monitor.info(String.format("API Authentication: basic auth configured with %s credential(s)", credentials.size()), new Throwable[0]);
        } else {
            monitor.warning("API Authentication: no basic auth credentials provided", new Throwable[0]);
        }
    }

    static class ConfigCredentials {
        private final String username;
        private final String vaultKey;

        ConfigCredentials(String username, String vaultKey) {
            this.username = username;
            this.vaultKey = vaultKey;
        }

        public String getUsername() {
            return this.username;
        }

        public String getVaultKey() {
            return this.vaultKey;
        }
    }
}

