/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.protocolversion.v4alpha;

import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import org.eclipse.edc.connector.controlplane.api.management.protocolversion.v4alpha.ProtocolVersionApiV4alpha;
import org.eclipse.edc.connector.controlplane.protocolversion.spi.ProtocolVersionRequest;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.VersionService;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.BadGatewayException;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v4alpha/protocol-versions")
public class ProtocolVersionApiV4AlphaController
implements ProtocolVersionApiV4alpha {
    private final VersionService service;
    private final TypeTransformerRegistry transformerRegistry;
    private final JsonObjectValidatorRegistry validatorRegistry;

    public ProtocolVersionApiV4AlphaController(VersionService service, TypeTransformerRegistry transformerRegistry, JsonObjectValidatorRegistry validatorRegistry) {
        this.service = service;
        this.transformerRegistry = transformerRegistry;
        this.validatorRegistry = validatorRegistry;
    }

    @Override
    @POST
    @Path(value="/request")
    public void requestProtocolVersionV4alpha(JsonObject requestBody, @Suspended AsyncResponse response) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/ProtocolVersionRequest", requestBody).orElseThrow(ValidationFailureException::new);
        ProtocolVersionRequest request = (ProtocolVersionRequest)this.transformerRegistry.transform((Object)requestBody, ProtocolVersionRequest.class).orElseThrow(InvalidRequestException::new);
        this.service.requestVersions(request).whenComplete((result, throwable) -> {
            try {
                response.resume((Object)this.toResponse((StatusResult<byte[]>)result, (Throwable)throwable));
            }
            catch (Throwable mapped) {
                response.resume(mapped);
            }
        });
    }

    private byte[] toResponse(StatusResult<byte[]> result, Throwable throwable) throws Throwable {
        if (throwable == null) {
            if (result.succeeded()) {
                return (byte[])result.getContent();
            }
            throw new BadGatewayException(result.getFailureDetail());
        }
        if (throwable instanceof EdcException || throwable.getCause() instanceof EdcException) {
            throw new BadGatewayException(throwable.getMessage());
        }
        throw throwable;
    }
}

