/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.protocolversion.v4alpha;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonObject;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;

@OpenAPIDefinition(info=@Info(version="v4alpha"))
@Tag(name="Protocol Version v4alpha")
public interface ProtocolVersionApiV4alpha {
    @Operation(requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ProtocolVersionRequestSchema.class))}), responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=ProtocolVersionSchema.class))}, description="Gets supported protocol versions of a single connector")})
    public void requestProtocolVersionV4alpha(JsonObject var1, @Suspended AsyncResponse var2);

    @Schema(name="ProtocolVersion", description="Protocol Version", example="{\n     \"protocolVersions\": [\n         {\n             \"version\": \"2024/1\",\n             \"path\": \"/2024/1\"\n         },\n         {\n             \"version\": \"v0.8\",\n             \"path\": \"/\"\n         }\n     ]\n }\n")
    public record ProtocolVersionSchema() {
        public static final String PROTOCOL_VERSION_EXAMPLE = "{\n     \"protocolVersions\": [\n         {\n             \"version\": \"2024/1\",\n             \"path\": \"/2024/1\"\n         },\n         {\n             \"version\": \"v0.8\",\n             \"path\": \"/\"\n         }\n     ]\n }\n";
    }

    @Schema(name="CatalogRequest", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"ProtocolVersionRequest\",\n    \"counterPartyAddress\": \"http://provider-address\",\n    \"counterPartyId\": \"providerId\",\n    \"protocol\": \"dataspace-protocol-http\"\n}\n")
    public record ProtocolVersionRequestSchema(@Schema(name="@context", requiredMode=Schema.RequiredMode.REQUIRED) Object context, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/CatalogRequest") String type, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String counterPartyAddress, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String counterPartyId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String protocol) {
        public static final String PROTOCOL_VERSION_REQUEST_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"ProtocolVersionRequest\",\n    \"counterPartyAddress\": \"http://provider-address\",\n    \"counterPartyId\": \"providerId\",\n    \"protocol\": \"dataspace-protocol-http\"\n}\n";
    }
}

