/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import org.embulk.input.jdbc.JdbcInputConnection;

public class SQLServerInputConnection
extends JdbcInputConnection {
    private String transactionIsolationLevel;

    public SQLServerInputConnection(Connection connection, String schemaName) throws SQLException {
        super(connection, schemaName);
    }

    public SQLServerInputConnection(Connection connection, String schemaName, String transactionIsolationLevel) throws SQLException {
        super(connection, schemaName);
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    protected void setSearchPath(String schema) throws SQLException {
    }

    protected String buildTableName(String tableName) {
        StringBuilder sb = new StringBuilder();
        if (this.schemaName != null) {
            sb.append(this.quoteIdentifierString(this.schemaName)).append(".");
        }
        sb.append(this.quoteIdentifierString(tableName));
        if (this.transactionIsolationLevel != null) {
            sb.append(" with (" + this.transactionIsolationLevel + ")");
        }
        return sb.toString();
    }
}

