/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.validation.constraints.Size;
import org.embulk.config.ConfigException;
import org.embulk.input.jdbc.AbstractJdbcInputPlugin;
import org.embulk.input.jdbc.JdbcInputConnection;
import org.embulk.input.jdbc.getter.ColumnGetterFactory;
import org.embulk.input.sqlserver.SQLServerInputConnection;
import org.embulk.input.sqlserver.getter.SQLServerColumnGetterFactory;
import org.embulk.spi.PageBuilder;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerInputPlugin
extends AbstractJdbcInputPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SQLServerInputPlugin.class);
    private static final int DEFAULT_PORT = 1433;

    protected Class<? extends AbstractJdbcInputPlugin.PluginTask> getTaskClass() {
        return SQLServerPluginTask.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcInputConnection newConnection(AbstractJdbcInputPlugin.PluginTask task) throws SQLException {
        Driver driver;
        boolean useJtdsDriver;
        SQLServerPluginTask sqlServerTask = (SQLServerPluginTask)task;
        if (sqlServerTask.getDriverPath().isPresent()) {
            this.addDriverJarToClasspath(sqlServerTask.getDriverPath().get());
        }
        if (sqlServerTask.getDriverType().equalsIgnoreCase("mssql-jdbc")) {
            useJtdsDriver = false;
            try {
                driver = (Driver)Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver").newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Can't load Microsoft SQLServerDriver from classpath", (Throwable)e);
            }
        } else if (sqlServerTask.getDriverType().equalsIgnoreCase("jtds")) {
            useJtdsDriver = true;
            try {
                driver = (Driver)Class.forName("net.sourceforge.jtds.jdbc.Driver").newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Can't load jTDS Driver from classpath", (Throwable)e);
            }
        } else {
            throw new ConfigException("Unknown driver_type : " + sqlServerTask.getDriverType());
        }
        UrlAndProperties urlAndProps = this.buildUrlAndProperties(sqlServerTask, useJtdsDriver);
        Properties props = urlAndProps.getProperties();
        props.putAll((Map<?, ?>)sqlServerTask.getOptions());
        this.logConnectionProperties(urlAndProps.getUrl(), props);
        if (driver != null) {
            try (Connection con = driver.connect(urlAndProps.getUrl(), props);){
                SQLServerInputConnection c = new SQLServerInputConnection(con, sqlServerTask.getSchema().orElse(null), sqlServerTask.getTransactionIsolationLevel().orElse(null));
                con = null;
                SQLServerInputConnection sQLServerInputConnection = c;
                return sQLServerInputConnection;
            }
        }
        throw new ConfigException("Fail to create new connection");
    }

    protected ColumnGetterFactory newColumnGetterFactory(PageBuilder pageBuilder, ZoneId dateTimeZone) {
        return new SQLServerColumnGetterFactory(pageBuilder, dateTimeZone);
    }

    private UrlAndProperties buildUrlAndProperties(SQLServerPluginTask sqlServerTask, boolean useJtdsDriver) {
        String url;
        Properties props = new Properties();
        if (sqlServerTask.getUser().isPresent()) {
            props.setProperty("user", sqlServerTask.getUser().get());
        }
        props.setProperty("password", sqlServerTask.getPassword());
        if (useJtdsDriver) {
            props.setProperty("loginTimeout", String.valueOf(sqlServerTask.getConnectTimeout()));
            props.setProperty("socketTimeout", String.valueOf(sqlServerTask.getSocketTimeout()));
            props.setProperty("appName", sqlServerTask.getApplicationName());
        } else {
            props.setProperty("loginTimeout", String.valueOf(sqlServerTask.getConnectTimeout()));
            props.setProperty("socketTimeout", String.valueOf((long)sqlServerTask.getSocketTimeout() * 1000L));
            props.setProperty("applicationName", sqlServerTask.getApplicationName());
        }
        if (sqlServerTask.getUrl().isPresent()) {
            if (sqlServerTask.getHost().isPresent() || sqlServerTask.getInstance().isPresent() || sqlServerTask.getDatabase().isPresent()) {
                throw new ConfigException("'host', 'instance' and 'database' options are invalid if 'url' option is set.");
            }
            return new UrlAndProperties(sqlServerTask.getUrl().get(), props);
        }
        if (!sqlServerTask.getHost().isPresent()) {
            throw new ConfigException("'host' option is required but not set.");
        }
        if (useJtdsDriver) {
            if (sqlServerTask.getInstance().isPresent()) {
                if (sqlServerTask.getPort() != 1433) {
                    logger.warn("'port: {}' option is ignored because instance option is set", (Object)sqlServerTask.getPort());
                }
                url = String.format(Locale.ENGLISH, "jdbc:jtds:sqlserver://%s", sqlServerTask.getHost().get());
                props.setProperty("instance", sqlServerTask.getInstance().get());
            } else {
                url = String.format(Locale.ENGLISH, "jdbc:jtds:sqlserver://%s:%d", sqlServerTask.getHost().get(), sqlServerTask.getPort());
            }
            if (sqlServerTask.getDatabase().isPresent()) {
                url = url + "/" + sqlServerTask.getDatabase().get();
            }
            if (sqlServerTask.getIntegratedSecurity()) {
                throw new ConfigException("'integratedSecutiry' option is not supported with jTDS driver. Set 'driver_path: /path/to/sqljdbc.jar' option if you want to use Microsoft SQLServerDriver.");
            }
            if (!sqlServerTask.getUser().isPresent()) {
                throw new ConfigException("'user' option is required but not set.");
            }
        } else {
            if (sqlServerTask.getInstance().isPresent()) {
                if (sqlServerTask.getPort() != 1433) {
                    logger.warn("'port: {}' option is ignored because instance option is set", (Object)sqlServerTask.getPort());
                }
                url = String.format(Locale.ENGLISH, "jdbc:sqlserver://%s\\%s", sqlServerTask.getHost().get(), sqlServerTask.getInstance().get());
            } else {
                url = String.format(Locale.ENGLISH, "jdbc:sqlserver://%s:%d", sqlServerTask.getHost().get(), sqlServerTask.getPort());
            }
            if (sqlServerTask.getDatabase().isPresent()) {
                props.setProperty("databaseName", sqlServerTask.getDatabase().get());
            }
            if (sqlServerTask.getIntegratedSecurity()) {
                if (sqlServerTask.getUser().isPresent()) {
                    throw new ConfigException("'user' options are invalid if 'integratedSecutiry' option is set.");
                }
                props.setProperty("integratedSecurity", "true");
                props.setProperty("authenticationScheme", "JavaKerberos");
            } else if (!sqlServerTask.getUser().isPresent()) {
                throw new ConfigException("'user' option is required but not set.");
            }
        }
        return new UrlAndProperties(url, props);
    }

    private static class UrlAndProperties {
        private final String url;
        private final Properties properties;

        public UrlAndProperties(String url, Properties properties) {
            this.url = url;
            this.properties = properties;
        }

        public String getUrl() {
            return this.url;
        }

        public Properties getProperties() {
            return this.properties;
        }
    }

    public static interface SQLServerPluginTask
    extends AbstractJdbcInputPlugin.PluginTask {
        @Config(value="driver_path")
        @ConfigDefault(value="null")
        public Optional<String> getDriverPath();

        @Config(value="driver_type")
        @ConfigDefault(value="\"mssql-jdbc\"")
        public String getDriverType();

        @Config(value="host")
        @ConfigDefault(value="null")
        public Optional<String> getHost();

        @Config(value="port")
        @ConfigDefault(value="1433")
        public int getPort();

        @Config(value="instance")
        @ConfigDefault(value="null")
        public Optional<String> getInstance();

        @Config(value="database")
        @ConfigDefault(value="null")
        public Optional<String> getDatabase();

        @Config(value="integratedSecurity")
        @ConfigDefault(value="false")
        public boolean getIntegratedSecurity();

        @Config(value="url")
        @ConfigDefault(value="null")
        public Optional<String> getUrl();

        @Config(value="user")
        @ConfigDefault(value="null")
        public Optional<String> getUser();

        @Config(value="password")
        @ConfigDefault(value="\"\"")
        public String getPassword();

        @Config(value="schema")
        @ConfigDefault(value="null")
        public Optional<String> getSchema();

        @Config(value="transaction_isolation_level")
        @ConfigDefault(value="null")
        public Optional<String> getTransactionIsolationLevel();

        @Config(value="application_name")
        @ConfigDefault(value="\"embulk-input-sqlserver\"")
        @Size(max=128)
        public String getApplicationName();
    }
}

