/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.sqlserver.getter;

import java.time.ZoneId;
import org.embulk.input.jdbc.AbstractJdbcInputPlugin;
import org.embulk.input.jdbc.JdbcColumn;
import org.embulk.input.jdbc.JdbcColumnOption;
import org.embulk.input.jdbc.JdbcInputConnection;
import org.embulk.input.jdbc.getter.ColumnGetter;
import org.embulk.input.jdbc.getter.ColumnGetterFactory;
import org.embulk.input.jdbc.getter.StringColumnGetter;
import org.embulk.input.jdbc.getter.TimestampWithoutTimeZoneIncrementalHandler;
import org.embulk.spi.PageBuilder;

public class SQLServerColumnGetterFactory
extends ColumnGetterFactory {
    public SQLServerColumnGetterFactory(PageBuilder to, ZoneId defaultTimeZone) {
        super(to, defaultTimeZone);
    }

    public ColumnGetter newColumnGetter(JdbcInputConnection con, AbstractJdbcInputPlugin.PluginTask task, JdbcColumn column, JdbcColumnOption option) {
        switch (column.getTypeName()) {
            case "date": 
            case "datetime2": 
            case "time": 
            case "sql_variant": 
            case "datetimeoffset": {
                return new StringColumnGetter(this.to, this.getToType(option));
            }
            case "datetime": {
                ColumnGetter getter = super.newColumnGetter(con, task, column, option);
                return new TimestampWithoutTimeZoneIncrementalHandler(getter);
            }
        }
        return super.newColumnGetter(con, task, column, option);
    }
}

