/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.enumerable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.enumerable.lambda.Fn1;
import org.enumerable.lambda.Fn2;
import org.enumerable.lambda.enumerable.collection.EnumerableModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
extends EnumerableModule<Integer> {
    public final int start;
    public final int end;
    public final boolean exclusive;

    public Range(int start, int end) {
        this(start, end, false);
    }

    public Range(int start, int end, boolean exclusive) {
        this.start = start;
        this.end = end;
        this.exclusive = exclusive;
    }

    public <R> Range each(Fn1<? super Integer, R> block) {
        return (Range)super.each(block);
    }

    public <R> Range eachWithIndex(Fn2<? super Integer, Integer, R> block) {
        return (Range)super.eachWithIndex(block);
    }

    public <R> Range reverseEach(Fn1<? super Integer, R> block) {
        return (Range)super.reverseEach(block);
    }

    public int[] toArray() {
        int[] array = new int[(this.exclusive ? this.end : this.end + 1) - this.start];
        int i = 0;
        for (Integer integer : this) {
            array[i++] = integer;
        }
        return array;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int x;
            {
                this.x = Range.this.start;
            }

            @Override
            public boolean hasNext() {
                return Range.this.exclusive ? this.x < Range.this.end : this.x <= Range.this.end;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.x++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

