/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.exception;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class UncheckedException
extends RuntimeException {
    public static Set<String> filteredPackages = new HashSet<String>();
    Throwable wrapped;

    public static Exception raise(Exception e) throws RuntimeException {
        throw UncheckedException.uncheck(e);
    }

    public static RuntimeException uncheck(Throwable t) {
        if (t.getCause() != null) {
            return UncheckedException.uncheck(t.getCause());
        }
        if (t instanceof RuntimeException) {
            t.setStackTrace(UncheckedException.filterStackTrace(t.getStackTrace()));
            return (RuntimeException)t;
        }
        return new UncheckedException(t);
    }

    UncheckedException(Throwable t) {
        super(t.getMessage(), t.getCause());
        this.wrapped = t;
        this.setStackTrace(UncheckedException.filterStackTrace(t.getStackTrace()));
    }

    static StackTraceElement[] filterStackTrace(StackTraceElement[] stackTrace) {
        ArrayList<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : stackTrace) {
            if (UncheckedException.isFilteredPackage(element)) continue;
            trace.add(element);
        }
        return trace.toArray(new StackTraceElement[0]);
    }

    static boolean isFilteredPackage(StackTraceElement element) {
        for (String prefix : filteredPackages) {
            if (!element.getClassName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String s = this.wrapped.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }

    static {
        filteredPackages.add("sun.reflect");
        filteredPackages.add("org.junit");
        filteredPackages.add("org.eclipse.jdt.internal");
        filteredPackages.add("java.lang.reflect");
    }
}

