/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.support.clojure;

import clojure.lang.ArraySeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Range;
import clojure.lang.Seqable;
import clojure.lang.Var;
import java.util.Comparator;
import org.enumerable.lambda.exception.UncheckedException;
import org.enumerable.lambda.support.clojure.LambdaClojure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClojureSeqs {
    public static boolean every(IFn pred, Seqable coll) {
        try {
            return (Boolean)Vars.every.invoke((Object)pred, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static boolean notEvery(IFn pred, Seqable coll) {
        try {
            return (Boolean)Vars.notEvery.invoke((Object)pred, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static boolean some(IFn pred, Seqable coll) {
        try {
            return (Boolean)Vars.some.invoke((Object)pred, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static boolean notAny(IFn pred, Seqable coll) {
        try {
            return (Boolean)Vars.notAny.invoke((Object)pred, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq concat() {
        try {
            return (ISeq)Vars.concat.invoke();
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq concat(Seqable x) {
        try {
            return (ISeq)Vars.concat.invoke((Object)x);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq concat(Seqable x, Seqable y) {
        try {
            return (ISeq)Vars.concat.invoke((Object)x, (Object)y);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq concat(Seqable x, Seqable y, Seqable ... zs) {
        try {
            return (ISeq)Vars.concat.applyTo(ArraySeq.create((Object[])zs).cons((Object)y).cons((Object)x));
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq map(IFn f, Seqable coll) {
        try {
            return (ISeq)Vars.map.invoke((Object)f, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq map(IFn f, Seqable c1, Seqable c2) {
        try {
            return (ISeq)Vars.map.invoke((Object)f, (Object)c1, (Object)c2);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq map(IFn f, Seqable c1, Seqable c2, Seqable c3) {
        try {
            return (ISeq)Vars.map.invoke((Object)f, (Object)c1, (Object)c2, (Object)c3);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq mapcat(IFn f, Seqable ... colls) {
        try {
            return (ISeq)Vars.mapcat.applyTo(ArraySeq.create((Object[])colls).cons((Object)f));
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq pmap(IFn f, Seqable coll) {
        try {
            return (ISeq)Vars.pmap.invoke((Object)f, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq pmap(IFn f, Seqable coll, Seqable ... colls) {
        try {
            return (ISeq)Vars.pmap.applyTo(ArraySeq.create((Object[])colls).cons((Object)coll).cons((Object)f));
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq filter(IFn pred, Seqable coll) {
        try {
            return (ISeq)Vars.filter.invoke((Object)pred, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static <R> R reduce(IFn f, Seqable coll) {
        try {
            return (R)Vars.reduce.invoke((Object)f, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static <R> R reduce(IFn f, R start, Seqable coll) {
        try {
            return (R)Vars.reduce.invoke((Object)f, start, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq take(Number n, Seqable coll) {
        try {
            return (ISeq)Vars.take.invoke((Object)n, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq takeNth(Number n, Seqable coll) {
        try {
            return (ISeq)Vars.takeNth.invoke((Object)n, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq takeWhile(IFn pred, Seqable coll) {
        try {
            return (ISeq)Vars.takeWhile.invoke((Object)pred, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq takeLast(Number n, Seqable coll) {
        try {
            return (ISeq)Vars.takeLast.invoke((Object)n, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq drop(Number n, Seqable coll) {
        try {
            return (ISeq)Vars.drop.invoke((Object)n, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq dropLast(Seqable s) {
        try {
            return (ISeq)Vars.dropLast.invoke((Object)s);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq dropLast(Number n, Seqable s) {
        try {
            return (ISeq)Vars.dropLast.invoke((Object)n, (Object)s);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq dropWhile(IFn pred, Seqable coll) {
        try {
            return (ISeq)Vars.dropWhile.invoke((Object)pred, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq reverse(Seqable coll) {
        try {
            return (ISeq)Vars.reverse.invoke((Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq cycle(Seqable coll) {
        try {
            return (ISeq)Vars.cycle.invoke((Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq interleave(Seqable c1, Seqable c2) {
        try {
            return (ISeq)Vars.interleave.invoke((Object)c1, (Object)c2);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq interleave(Seqable c1, Seqable c2, Seqable ... colls) {
        try {
            return (ISeq)Vars.interleave.applyTo(ArraySeq.create((Object[])colls).cons((Object)c2).cons((Object)c1));
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq interpose(Object sep, Seqable coll) {
        try {
            return (ISeq)Vars.interpose.invoke(sep, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq partition(Number n, Seqable coll) {
        try {
            return (ISeq)Vars.partition.invoke((Object)n, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq partition(Number n, Number step, Seqable coll) {
        try {
            return (ISeq)Vars.partition.invoke((Object)n, (Object)step, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq partition(Number n, Number step, Seqable pad, Seqable coll) {
        try {
            return (ISeq)Vars.partition.invoke((Object)n, (Object)step, (Object)pad, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static IPersistentVector splitAt(Number n, Seqable coll) {
        try {
            return (IPersistentVector)Vars.splitAt.invoke((Object)n, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static IPersistentVector splitWith(IFn pred, Seqable coll) {
        try {
            return (IPersistentVector)Vars.splitWith.invoke((Object)pred, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq repeat(Object x) {
        try {
            return (ISeq)Vars.repeat.invoke(x);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq repeat(Number n, Object x) {
        try {
            return (ISeq)Vars.repeat.invoke((Object)n, x);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq repeatedly(IFn f) {
        try {
            return (ISeq)Vars.repeatedly.invoke((Object)f);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq replicate(Number n, Object x) {
        try {
            return (ISeq)Vars.replicate.invoke((Object)n, x);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq iterate(IFn f, Object x) {
        try {
            return (ISeq)Vars.iterate.invoke((Object)f, x);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static Range range(Number end) {
        try {
            return (Range)Vars.range.invoke((Object)end);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static Range range(Number start, Number end) {
        try {
            return (Range)Vars.range.invoke((Object)start, (Object)end);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static Range range(Number start, Number end, Number step) {
        try {
            return (Range)Vars.range.invoke((Object)start, (Object)end, (Object)step);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq into(Seqable to, Seqable from) {
        try {
            return (ISeq)Vars.into.invoke((Object)to, (Object)from);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq distinct(Seqable coll) {
        try {
            return (ISeq)Vars.distinct.invoke((Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static IPersistentSet set(Seqable coll) {
        try {
            return (IPersistentSet)Vars.set.invoke((Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static IPersistentVector vec(Seqable coll) {
        try {
            return (IPersistentVector)Vars.vec.invoke((Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static Object dorun(Seqable coll) {
        try {
            return Vars.dorun.invoke((Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static Object dorun(Number n, Seqable coll) {
        try {
            return Vars.dorun.invoke((Object)n, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq doall(Seqable coll) {
        try {
            return (ISeq)Vars.doall.invoke((Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq doall(Number n, Seqable coll) {
        try {
            return (ISeq)Vars.doall.invoke((Object)n, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq sort(Object coll) {
        try {
            return (ISeq)Vars.sort.invoke(coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq sort(Comparator<?> comp, Seqable coll) {
        try {
            return (ISeq)Vars.sort.invoke(comp, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq sortBy(IFn keyfn, Seqable coll) {
        try {
            return (ISeq)Vars.sortBy.invoke((Object)keyfn, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static ISeq sortBy(IFn keyfn, Comparator<?> comp, Seqable coll) {
        try {
            return (ISeq)Vars.sortBy.invoke((Object)keyfn, comp, (Object)coll);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static IPersistentMap zipmap(Seqable keys, Seqable vals) {
        try {
            return (IPersistentMap)Vars.zipmap.invoke((Object)keys, (Object)vals);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    static {
        LambdaClojure.init();
    }

    public static class Vars {
        public static Var every = RT.var((String)"clojure.core", (String)"every?");
        public static Var notEvery = RT.var((String)"clojure.core", (String)"not-every?");
        public static Var some = RT.var((String)"clojure.core", (String)"some");
        public static Var notAny = RT.var((String)"clojure.core", (String)"not-any?");
        public static Var concat = RT.var((String)"clojure.core", (String)"concat");
        public static Var map = RT.var((String)"clojure.core", (String)"map");
        public static Var mapcat = RT.var((String)"clojure.core", (String)"mapcat");
        public static Var pmap = RT.var((String)"clojure.core", (String)"pmap");
        public static Var filter = RT.var((String)"clojure.core", (String)"filter");
        public static Var reduce = RT.var((String)"clojure.core", (String)"reduce");
        public static Var take = RT.var((String)"clojure.core", (String)"take");
        public static Var takeNth = RT.var((String)"clojure.core", (String)"take-nth");
        public static Var takeWhile = RT.var((String)"clojure.core", (String)"take-while");
        public static Var takeLast = RT.var((String)"clojure.core", (String)"take-last");
        public static Var drop = RT.var((String)"clojure.core", (String)"drop");
        public static Var dropWhile = RT.var((String)"clojure.core", (String)"drop-while");
        public static Var dropLast = RT.var((String)"clojure.core", (String)"drop-last");
        public static Var reverse = RT.var((String)"clojure.core", (String)"reverse");
        public static Var cycle = RT.var((String)"clojure.core", (String)"cycle");
        public static Var interleave = RT.var((String)"clojure.core", (String)"interleave");
        public static Var interpose = RT.var((String)"clojure.core", (String)"interpose");
        public static Var partition = RT.var((String)"clojure.core", (String)"partition");
        public static Var splitAt = RT.var((String)"clojure.core", (String)"split-at");
        public static Var splitWith = RT.var((String)"clojure.core", (String)"split-with");
        public static Var repeat = RT.var((String)"clojure.core", (String)"repeat");
        public static Var repeatedly = RT.var((String)"clojure.core", (String)"repeatedly");
        public static Var replicate = RT.var((String)"clojure.core", (String)"replicate");
        public static Var iterate = RT.var((String)"clojure.core", (String)"iterate");
        public static Var range = RT.var((String)"clojure.core", (String)"range");
        public static Var into = RT.var((String)"clojure.core", (String)"into");
        public static Var distinct = RT.var((String)"clojure.core", (String)"distinct");
        public static Var set = RT.var((String)"clojure.core", (String)"set");
        public static Var vec = RT.var((String)"clojure.core", (String)"vec");
        public static Var dorun = RT.var((String)"clojure.core", (String)"dorun");
        public static Var doall = RT.var((String)"clojure.core", (String)"doall");
        public static Var sort = RT.var((String)"clojure.core", (String)"sort");
        public static Var sortBy = RT.var((String)"clojure.core", (String)"sort-by");
        public static Var zipmap = RT.var((String)"clojure.core", (String)"zipmap");
    }
}

