/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ClassFilter {
    private Set<String> packagesToSkip = new HashSet<String>(){
        {
            this.add("java.");
            this.add("javax.");
            this.add("sun.");
            this.add("$Proxy");
            this.add("org.eclipse.jdt.internal.");
            this.add("org.junit.");
            this.add("junit.");
            this.add("com.sun.");
            this.add("clojure.");
            this.add("org.jruby.");
            this.add("org.codehaus.groovy.");
            this.add("org.osgi.");
            this.add("org.enumerable.lambda.weaving.");
            this.add("org.enumerable.lambda.asm.");
            this.add("groovy.");
            this.add("scala.");
            this.add("Script");
            this.add("org.enumerable.lambda.enumerable.jruby.");
            this.add("Enumerable");
        }
    };
    private Set<String> packagesToInclude = new HashSet<String>();
    private Pattern excludePattern;

    public ClassFilter(String skippedPackages, String includedPackages, String excludePatternString) {
        this.addSkippedPackages(skippedPackages);
        this.addIncludedPackages(includedPackages);
        if (!"".equals(excludePatternString.trim())) {
            this.excludePattern = Pattern.compile(excludePatternString);
        }
    }

    public static ClassFilter createClassFilter() {
        return new ClassFilter(System.getProperty("lambda.weaving.skipped.packages", ""), System.getProperty("lambda.weaving.included.packages", ""), System.getProperty("lambda.weaving.exclude.pattern", ""));
    }

    private void addIncludedPackages(String agentArgs) {
        for (String prefix : agentArgs.split(",")) {
            String trim = prefix.trim();
            if (trim.length() <= 0) continue;
            this.packagesToInclude.add(trim);
        }
    }

    private void addSkippedPackages(String agentArgs) {
        for (String prefix : agentArgs.split(",")) {
            String trim = prefix.trim();
            if (trim.length() <= 0) continue;
            this.packagesToSkip.add(trim);
        }
    }

    public boolean isToBeInstrumented(String name) {
        return this.packageIncluded(name) && (this.excludePattern == null || !this.excludePattern.matcher(name).find());
    }

    private boolean packageIncluded(String name) {
        if (this.packagesToInclude.size() > 0) {
            for (String prefix : this.packagesToInclude) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        for (String prefix : this.packagesToSkip) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }
}

