/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.enumerable.lambda.exception.UncheckedException;
import org.enumerable.lambda.weaving.ClassFilter;
import org.enumerable.lambda.weaving.Debug;
import org.enumerable.lambda.weaving.Version;
import org.enumerable.lambda.weaving.tree.LambdaTreeTransformer;

public class LambdaCompiler {
    static final String AOT_COMPILED_MARKER = "META-INF/lambda.aot.compiled";
    LambdaTreeTransformer transformer = new LambdaTreeTransformer();
    byte[] buffer = new byte[8192];

    public static void main(String[] args) throws Exception {
        System.out.println("[compiler] " + Version.getVersionString());
        if (args.length == 0) {
            System.out.println("Usage: <jar>|<dir>...");
            return;
        }
        for (String name : args) {
            File file = new File(name);
            if (file.isDirectory() || file.getName().endsWith(".jar")) continue;
            System.out.println(file.getAbsolutePath() + " is neither a jar or a directory, exiting");
            System.exit(1);
        }
        new LambdaCompiler().compile(args);
    }

    void compile(String[] args) throws Exception {
        for (String name : args) {
            File file = new File(name);
            Debug.debug("compiling " + file.getPath());
            if (file.isDirectory()) {
                this.compileClassesDirectory(file);
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            this.compilieJar(file);
        }
    }

    private void compileClassesDirectory(File file) throws Exception {
        File aotCompiledMarker = new File(file, AOT_COMPILED_MARKER);
        if (aotCompiledMarker.exists()) {
            System.out.println(file + " is already compiled, skipping.");
            return;
        }
        aotCompiledMarker.getParentFile().mkdir();
        aotCompiledMarker.createNewFile();
        this.ensureCreated(aotCompiledMarker);
        this.compileDirectory(file);
        Debug.debug("writing generated lambdas in " + file);
        this.writeGeneratedLambdas(file);
    }

    void compileDirectory(File dir) throws Exception {
        for (File file : dir.listFiles()) {
            if (file.getName().endsWith(".class")) {
                this.compileFile(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.compileDirectory(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileFile(File file) throws Exception {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(file);
            byte[] bs = this.transformer.transform(ClassLoader.getSystemClassLoader(), ClassFilter.createClassFilter(), null, in);
            in.close();
            if (bs != null) {
                out = new FileOutputStream(file);
                out.write(bs);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException silent) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException silent) {}
            }
        }
    }

    void compilieJar(File jar) throws Exception {
        try {
            JarFile jarFile = new JarFile(jar);
            if (jarFile.getEntry(AOT_COMPILED_MARKER) != null) {
                System.out.println(jar + " is already compiled, skipping.");
                return;
            }
            File tempDir = this.unjar(jarFile);
            File aotCompiledMarker = new File(tempDir, AOT_COMPILED_MARKER);
            aotCompiledMarker.getParentFile().mkdir();
            aotCompiledMarker.createNewFile();
            this.ensureCreated(aotCompiledMarker);
            this.compileDirectory(tempDir);
            Debug.debug("writing generated lambdas in " + jar);
            this.writeGeneratedLambdas(tempDir);
            File newJar = this.jar(tempDir);
            File bak = new File(jar.getAbsolutePath() + ".bak");
            this.rename(jar, bak);
            this.ensureCreated(bak);
            this.rename(newJar, jar);
            this.ensureCreated(jar);
            this.delete(bak);
            this.delete(tempDir);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    private void rename(File from, File to) {
        if (!from.renameTo(to)) {
            throw new IllegalStateException("Could not rename " + from + " to " + to);
        }
    }

    void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        file.delete();
    }

    void ensureCreated(File file) {
        if (!file.isFile()) {
            throw new IllegalStateException("Could not create " + file);
        }
    }

    void ensureDirCreated(File dir) throws IOException {
        if (!dir.mkdir()) {
            throw new IOException("Could not create directory " + dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeGeneratedLambdas(File tempDir) throws IOException {
        for (Map.Entry<String, byte[]> lambdaClass : this.transformer.getLambdasByClassName().entrySet()) {
            File lambdaFile = new File(tempDir, lambdaClass.getKey().replace('.', '/'));
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(lambdaFile + ".class");
                out.write(lambdaClass.getValue());
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File jar(File dir) throws Exception {
        File newJar = new File(dir.getAbsolutePath() + ".jar");
        ZipOutputStream out = null;
        try {
            out = new JarOutputStream(new FileOutputStream(newJar));
            this.addDirToJar(dir, dir, (JarOutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return newJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirToJar(File baseDir, File dir, JarOutputStream out) throws IOException {
        for (File file : dir.listFiles()) {
            JarEntry jarEntry;
            String nameInJar = file.getPath().substring(baseDir.getPath().length() + 1).replace(File.separatorChar, '/');
            if (file.isDirectory()) {
                jarEntry = new JarEntry(nameInJar.endsWith("/") ? nameInJar : nameInJar + "/");
                jarEntry.setTime(file.lastModified());
                out.putNextEntry(jarEntry);
                out.closeEntry();
                this.addDirToJar(baseDir, file, out);
                continue;
            }
            jarEntry = new JarEntry(nameInJar);
            jarEntry.setTime(file.lastModified());
            out.putNextEntry(jarEntry);
            FileInputStream in = null;
            try {
                int read;
                in = new FileInputStream(file);
                while ((read = ((InputStream)in).read(this.buffer)) != -1) {
                    out.write(this.buffer, 0, read);
                }
                out.closeEntry();
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File unjar(JarFile jarFile) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        File tempDir = new File(System.getProperty("java.io.tmpdir"), new File(jarFile.getName()).getName() + "-" + System.currentTimeMillis());
        this.ensureDirCreated(tempDir);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                int read;
                JarEntry jarEntry = entries.nextElement();
                File file = new File(tempDir, jarEntry.getName());
                if (jarEntry.isDirectory()) {
                    file.mkdir();
                    continue;
                }
                file.getParentFile().mkdirs();
                in = jarFile.getInputStream(jarEntry);
                out = new FileOutputStream(file);
                while ((read = in.read(this.buffer)) != -1) {
                    out.write(this.buffer, 0, read);
                }
                out.flush();
            }
            File file = tempDir;
            return file;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            jarFile.close();
        }
    }
}

