/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.enumerable.lambda.exception.UncheckedException;

public class Version {
    public static Properties buildProperties = new Properties();

    public static String getVersion() {
        return (String)buildProperties.get("enumerable.version");
    }

    public static String getBuildDate() {
        return buildProperties.getProperty("enumerable.build.date");
    }

    public static String getGitCommit() {
        return buildProperties.getProperty("enumerable.git.commit");
    }

    public static String getVersionString() {
        return "Enumerable.java version " + Version.getVersion() + " (built on " + Version.getBuildDate() + " from " + Version.getGitCommit() + ")";
    }

    static {
        ClassLoader loader = Version.class.getClassLoader();
        InputStream in = loader.getResourceAsStream(Version.class.getName().toLowerCase().replace('.', '/') + ".properties");
        try {
            if (in != null) {
                buildProperties.load(in);
            }
        }
        catch (IOException e) {
            throw UncheckedException.uncheck(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException silent) {}
        }
    }
}

