/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.PreparedStatementInformation;
import java.util.HashMap;
import java.util.Map;

public class CallableStatementInformation
extends PreparedStatementInformation {
    private final Map<String, Object> namedParameterValues = new HashMap<String, Object>();

    public CallableStatementInformation(ConnectionInformation connectionInformation, String query) {
        super(connectionInformation, query);
    }

    @Override
    public String getSqlWithValues() {
        if (this.namedParameterValues.size() == 0) {
            return super.getSqlWithValues();
        }
        StringBuilder result = new StringBuilder();
        String statementQuery = this.getStatementQuery();
        result.append(statementQuery);
        result.append(" ");
        StringBuilder parameters = new StringBuilder();
        for (Integer position : this.getParameterValues().keySet()) {
            this.appendParameter(parameters, position.toString(), this.getParameterValues().get(position));
        }
        for (String name : this.namedParameterValues.keySet()) {
            this.appendParameter(parameters, name, this.namedParameterValues.get(name));
        }
        result.append((CharSequence)parameters);
        return result.toString();
    }

    private void appendParameter(StringBuilder parameters, String name, Object value) {
        if (parameters.length() > 0) {
            parameters.append(", ");
        }
        parameters.append(name);
        parameters.append(":");
        parameters.append(this.convertToString(value));
    }

    public void setParameterValue(String name, Object value) {
        this.namedParameterValues.put(name, value);
    }
}

