/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.spy.P6Core;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class P6PooledConnection
implements PooledConnection {
    protected PooledConnection passthru;

    public P6PooledConnection(PooledConnection connection) {
        this.passthru = connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        long start = System.nanoTime();
        Connection connection = this.passthru.getConnection();
        return P6Core.wrapConnection(connection, ConnectionInformation.fromPooledConnection(this.passthru, connection, System.nanoTime() - start));
    }

    @Override
    public void close() throws SQLException {
        this.passthru.close();
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener eventTarget) {
        this.passthru.addConnectionEventListener(eventTarget);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener eventTarget) {
        this.passthru.removeConnectionEventListener(eventTarget);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.passthru.addStatementEventListener(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.passthru.removeStatementEventListener(listener);
    }
}

