/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal.db;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evomaster.clientJava.controller.db.DataRow;
import org.evomaster.clientJava.controller.db.QueryResult;
import org.evomaster.clientJava.controller.internal.db.HeuristicsCalculator;
import shaded.net.sf.jsqlparser.expression.Alias;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.select.SelectBody;
import shaded.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import shaded.net.sf.jsqlparser.statement.select.SelectItem;
import shaded.net.sf.jsqlparser.statement.select.SetOperationList;
import shaded.net.sf.jsqlparser.statement.select.SubSelect;

public class SelectHeuristics {
    public static final String UNNAMED_TABLE = "___unnamed_table___";

    public static String addFieldsToSelect(String select) {
        Select stmt;
        try {
            stmt = (Select)CCJSqlParserUtil.parse(select);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Select SQL: " + select + "\n" + e.getMessage(), e);
        }
        SelectBody selectBody = stmt.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            Expression where = plainSelect.getWhere();
            if (where == null) {
                return select;
            }
            final List<SelectItem> fields = plainSelect.getSelectItems();
            where.accept(new ExpressionVisitorAdapter(){

                @Override
                public void visit(Column column) {
                    String target = column.toString();
                    boolean found = false;
                    for (SelectItem si : fields) {
                        SelectExpressionItem field = (SelectExpressionItem)si;
                        String exp = field.getExpression().toString();
                        if (!target.equals(exp)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        SelectExpressionItem item = new SelectExpressionItem();
                        item.setExpression(column);
                        fields.add(item);
                    }
                }
            });
        }
        return stmt.toString();
    }

    public static String removeConstraints(String select) {
        Select stmt;
        try {
            stmt = (Select)CCJSqlParserUtil.parse(select);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Select SQL: " + select + "\n" + e.getMessage(), e);
        }
        SelectBody selectBody = stmt.getSelectBody();
        SelectHeuristics.handleSelectBody(selectBody);
        return stmt.toString();
    }

    private static void handleSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            plainSelect.setWhere(null);
            plainSelect.setLimit(null);
        } else if (selectBody instanceof SetOperationList) {
            for (SelectBody select : ((SetOperationList)selectBody).getSelects()) {
                SelectHeuristics.handleSelectBody(select);
            }
        } else {
            throw new RuntimeException("Cannot handle " + selectBody.getClass());
        }
    }

    public static double computeDistance(String select, QueryResult data) {
        Select stmt;
        try {
            stmt = (Select)CCJSqlParserUtil.parse(select);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Select SQL: " + select + "\n" + e.getMessage(), e);
        }
        if (data.isEmpty()) {
            return Double.MAX_VALUE;
        }
        Expression where = SelectHeuristics.getWhere(stmt);
        if (where == null) {
            return 0.0;
        }
        Map<String, String> aliases = SelectHeuristics.getTableAliases(stmt);
        HeuristicsCalculator calculator = new HeuristicsCalculator(aliases);
        double min = Double.MAX_VALUE;
        for (DataRow row : data.seeRows()) {
            double dist = calculator.computeExpression(where, row);
            if (dist == 0.0) {
                return 0.0;
            }
            if (!(dist < min)) continue;
            min = dist;
        }
        return min;
    }

    public static Map<String, String> getTableAliases(Select select) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            fromItem.accept(new FromVisitor(aliases));
            List<Join> joins = plainSelect.getJoins();
            if (joins != null) {
                joins.forEach(j -> j.getRightItem().accept(new FromVisitor(aliases)));
            }
        }
        return aliases;
    }

    private static void handleAlias(Map<String, String> aliases, SubSelect subSelect) {
        String aliasName;
        Alias alias = subSelect.getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            String tableName = UNNAMED_TABLE;
            aliases.put(aliasName.trim().toLowerCase(), tableName.trim().toLowerCase());
        }
    }

    private static void handleAlias(Map<String, String> aliases, Table table) {
        String aliasName;
        Alias alias = table.getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            String tableName = table.getName();
            aliases.put(aliasName.trim().toLowerCase(), tableName.trim().toLowerCase());
        }
    }

    private static Expression getWhere(Select select) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            return plainSelect.getWhere();
        }
        return null;
    }

    private static class FromVisitor
    extends FromItemVisitorAdapter {
        private final Map<String, String> aliases;

        private FromVisitor(Map<String, String> aliases) {
            this.aliases = aliases;
        }

        @Override
        public void visit(Table table) {
            SelectHeuristics.handleAlias((Map<String, String>)this.aliases, table);
        }

        @Override
        public void visit(SubSelect subSelect) {
            SelectHeuristics.handleAlias((Map<String, String>)this.aliases, subSelect);
        }
    }
}

