/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal.db;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Objects;
import org.evomaster.clientJava.controller.internal.SutController;

public class StandardOutputTracker
extends ByteArrayOutputStream {
    private static final PrintStream DEFAULT_OUT = System.out;
    private volatile SutController sutController;

    public static void setTracker(boolean on, SutController sutController) {
        if (on) {
            System.setOut(new PrintStream(new StandardOutputTracker(sutController), true));
        } else {
            System.setOut(DEFAULT_OUT);
        }
    }

    private StandardOutputTracker(SutController sutController) {
        super(2048);
        this.sutController = sutController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        String data;
        StandardOutputTracker standardOutputTracker = this;
        synchronized (standardOutputTracker) {
            super.flush();
            data = this.toString();
            this.reset();
            DEFAULT_OUT.print(data);
        }
        if (data != null) {
            Arrays.stream(data.split("\n")).filter(l -> l.startsWith("P6SPY_SQL: ")).forEach(l -> StandardOutputTracker.handleSqlLine(this.sutController, l));
        }
    }

    public static void handleSqlLine(SutController sc, String line) {
        Objects.requireNonNull(sc);
        Objects.requireNonNull(line);
        if (!line.startsWith("P6SPY_SQL: ")) {
            throw new IllegalArgumentException("No P6Spy prefix");
        }
        String sql = line.substring("P6SPY_SQL: ".length());
        sc.handleSql(sql);
    }
}

