/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.evomaster.clientJava.instrumentation.TargetInfo;
import org.evomaster.clientJava.instrumentation.staticState.ExecutionTracer;
import org.evomaster.clientJava.instrumentation.staticState.ObjectiveRecorder;

public class InstrumentationController {
    public static void resetForNewSearch() {
        ExecutionTracer.reset();
        ObjectiveRecorder.reset(false);
    }

    public static void resetForNewTest() {
        ExecutionTracer.reset();
        ObjectiveRecorder.clearFirstTimeEncountered();
    }

    public static void newAction(int actionIndex) {
        ExecutionTracer.setActionIndex(actionIndex);
    }

    public static List<TargetInfo> getTargetInfos(Collection<Integer> ids) {
        ArrayList<TargetInfo> list = new ArrayList<TargetInfo>();
        Map<String, TargetInfo> objectives = ExecutionTracer.getInternalReferenceToObjectiveCoverage();
        ids.stream().forEach(id -> {
            String descriptiveId = ObjectiveRecorder.getDescriptiveId(id);
            TargetInfo info = (TargetInfo)objectives.get(descriptiveId);
            info = info == null ? TargetInfo.notReached(id) : info.withMappedId((int)id).withNoDescriptiveId();
            list.add(info);
        });
        ObjectiveRecorder.getTargetsSeenFirstTime().stream().forEach(s -> {
            int mappedId = ObjectiveRecorder.getMappedId(s);
            TargetInfo info = ((TargetInfo)objectives.get(s)).withMappedId(mappedId);
            list.add(info);
        });
        return list;
    }
}

