/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation.staticState;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.evomaster.clientJava.instrumentation.ObjectiveNaming;
import org.evomaster.clientJava.instrumentation.TargetInfo;
import org.evomaster.clientJava.instrumentation.heuristic.HeuristicsForJumps;
import org.evomaster.clientJava.instrumentation.heuristic.Truthness;
import org.evomaster.clientJava.instrumentation.staticState.ObjectiveRecorder;

public class ExecutionTracer {
    private static final Map<String, TargetInfo> objectiveCoverage = new ConcurrentHashMap<String, TargetInfo>(65536);
    private static int actionIndex = 0;
    public static final String EXECUTED_LINE_METHOD_NAME = "executedLine";
    public static final String EXECUTED_LINE_DESCRIPTOR = "(Ljava/lang/String;I)V";
    public static final String EXECUTING_METHOD_METHOD_NAME = "executingMethod";
    public static final String EXECUTING_METHOD_DESCRIPTOR = "(Ljava/lang/String;IIZ)V";
    public static final String EXECUTING_BRANCH_JUMP_METHOD_NAME = "executingBranchJump";
    public static final String JUMP_DESC_1_VALUE = "(IILjava/lang/String;II)V";
    public static final String JUMP_DESC_2_VALUES = "(IIILjava/lang/String;II)V";
    public static final String JUMP_DESC_OBJECTS = "(Ljava/lang/Object;Ljava/lang/Object;ILjava/lang/String;II)V";
    public static final String JUMP_DESC_NULL = "(Ljava/lang/Object;ILjava/lang/String;II)V";

    public static void reset() {
        objectiveCoverage.clear();
        actionIndex = 0;
    }

    public static void setActionIndex(int index) {
        actionIndex = index;
    }

    public static Map<String, TargetInfo> getInternalReferenceToObjectiveCoverage() {
        return objectiveCoverage;
    }

    public static int getNumberOfObjectives() {
        return objectiveCoverage.size();
    }

    public static int getNumberOfObjectives(String prefix) {
        return (int)objectiveCoverage.entrySet().stream().filter(e -> prefix == null || ((String)e.getKey()).startsWith(prefix)).count();
    }

    public static int getNumberOfNonCoveredObjectives(String prefix) {
        return ExecutionTracer.getNonCoveredObjectives(prefix).size();
    }

    public static Set<String> getNonCoveredObjectives(String prefix) {
        return objectiveCoverage.entrySet().stream().filter(e -> prefix == null || ((String)e.getKey()).startsWith(prefix)).filter(e -> ((TargetInfo)e.getValue()).value < 1.0).map(e -> (String)e.getKey()).collect(Collectors.toSet());
    }

    public static Double getValue(String id) {
        return ExecutionTracer.objectiveCoverage.get((Object)id).value;
    }

    private static void updateObjective(String id, double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Invalid value " + value + " out of range [0,1]");
        }
        if (objectiveCoverage.containsKey(id)) {
            double previous = ExecutionTracer.objectiveCoverage.get((Object)id).value;
            if (value > previous) {
                objectiveCoverage.put(id, new TargetInfo(null, id, value, actionIndex));
            }
        } else {
            objectiveCoverage.put(id, new TargetInfo(null, id, value, actionIndex));
        }
        ObjectiveRecorder.update(id, value);
    }

    public static void executedLine(String className, int line) {
        String lineId = ObjectiveNaming.lineObjectiveName(className, line);
        String classId = ObjectiveNaming.classObjectiveName(className);
        ExecutionTracer.updateObjective(lineId, 1.0);
        ExecutionTracer.updateObjective(classId, 1.0);
    }

    public static void executingMethod(String className, int line, int index, boolean completed) {
        String id = ObjectiveNaming.successCallObjectiveName(className, line, index);
        if (completed) {
            ExecutionTracer.updateObjective(id, 1.0);
        } else {
            ExecutionTracer.updateObjective(id, 0.5);
        }
    }

    private static void updateBranch(String className, int line, int branchId, Truthness t) {
        String forThen = ObjectiveNaming.branchObjectiveName(className, line, branchId, true);
        String forElse = ObjectiveNaming.branchObjectiveName(className, line, branchId, false);
        ExecutionTracer.updateObjective(forElse, t.getOfTrue());
        ExecutionTracer.updateObjective(forThen, t.getOfFalse());
    }

    public static void executingBranchJump(int value, int opcode, String className, int line, int branchId) {
        Truthness t = HeuristicsForJumps.getForSingleValueJump(value, opcode);
        ExecutionTracer.updateBranch(className, line, branchId, t);
    }

    public static void executingBranchJump(int firstValue, int secondValue, int opcode, String className, int line, int branchId) {
        Truthness t = HeuristicsForJumps.getForValueComparison(firstValue, secondValue, opcode);
        ExecutionTracer.updateBranch(className, line, branchId, t);
    }

    public static void executingBranchJump(Object first, Object second, int opcode, String className, int line, int branchId) {
        Truthness t = HeuristicsForJumps.getForObjectComparison(first, second, opcode);
        ExecutionTracer.updateBranch(className, line, branchId, t);
    }

    public static void executingBranchJump(Object obj, int opcode, String className, int line, int branchId) {
        Truthness t = HeuristicsForJumps.getForNullComparison(obj, opcode);
        ExecutionTracer.updateBranch(className, line, branchId, t);
    }
}

