/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.message.filtering;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import shaded.jersey.repackaged.com.google.common.collect.Lists;
import shaded.jersey.repackaged.com.google.common.collect.Sets;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.internal.inject.Providers;
import shaded.org.glassfish.jersey.internal.util.ReflectionHelper;
import shaded.org.glassfish.jersey.message.filtering.EntityProcessorContextImpl;
import shaded.org.glassfish.jersey.message.filtering.spi.EntityGraph;
import shaded.org.glassfish.jersey.message.filtering.spi.EntityGraphProvider;
import shaded.org.glassfish.jersey.message.filtering.spi.EntityInspector;
import shaded.org.glassfish.jersey.message.filtering.spi.EntityProcessor;
import shaded.org.glassfish.jersey.message.filtering.spi.EntityProcessorContext;
import shaded.org.glassfish.jersey.message.filtering.spi.FilteringHelper;
import shaded.org.glassfish.jersey.model.internal.RankedComparator;

@Singleton
final class EntityInspectorImpl
implements EntityInspector {
    private final List<EntityProcessor> entityProcessors;
    @Inject
    private EntityGraphProvider graphProvider;

    @Inject
    public EntityInspectorImpl(ServiceLocator locator) {
        this.entityProcessors = Lists.newArrayList(Providers.getAllProviders(locator, EntityProcessor.class, new RankedComparator()));
    }

    @Override
    public void inspect(Class<?> entityClass, boolean forWriter) {
        if (!this.graphProvider.containsEntityGraph(entityClass, forWriter)) {
            EntityGraph graph = this.graphProvider.getOrCreateEntityGraph(entityClass, forWriter);
            HashSet<Class<?>> inspect = Sets.newHashSet();
            if (!this.inspectEntityClass(entityClass, graph, forWriter)) {
                Map<String, Method> unmatchedAccessors = this.inspectEntityProperties(entityClass, graph, inspect, forWriter);
                this.inspectStandaloneAccessors(unmatchedAccessors, graph, forWriter);
                for (Class clazz : inspect) {
                    this.inspect(clazz, forWriter);
                }
            }
        }
    }

    private boolean inspectEntityClass(Class<?> entityClass, EntityGraph graph, boolean forWriter) {
        EntityProcessorContextImpl context = new EntityProcessorContextImpl(forWriter ? EntityProcessorContext.Type.CLASS_WRITER : EntityProcessorContext.Type.CLASS_READER, entityClass, graph);
        for (EntityProcessor processor : this.entityProcessors) {
            EntityProcessor.Result result = processor.process(context);
            if (EntityProcessor.Result.ROLLBACK != result) continue;
            this.graphProvider.getOrCreateEmptyEntityGraph(entityClass, false);
            return true;
        }
        return false;
    }

    private Map<String, Method> inspectEntityProperties(Class<?> entityClass, EntityGraph graph, Set<Class<?>> inspect, boolean forWriter) {
        Field[] fields = AccessController.doPrivileged(ReflectionHelper.getAllFieldsPA(entityClass));
        Map<String, Method> methods = FilteringHelper.getPropertyMethods(entityClass, forWriter);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String name = field.getName();
            Class<?> clazz = FilteringHelper.getEntityClass(field.getGenericType());
            Method method = methods.remove(name);
            EntityProcessorContextImpl context = new EntityProcessorContextImpl(forWriter ? EntityProcessorContext.Type.PROPERTY_WRITER : EntityProcessorContext.Type.PROPERTY_READER, field, method, graph);
            boolean rollback = false;
            for (EntityProcessor processor : this.entityProcessors) {
                EntityProcessor.Result result = processor.process(context);
                if (EntityProcessor.Result.ROLLBACK != result) continue;
                rollback = true;
                graph.remove(name);
                break;
            }
            if (rollback || !FilteringHelper.filterableEntityClass(clazz)) continue;
            inspect.add(clazz);
        }
        return methods;
    }

    private void inspectStandaloneAccessors(Map<String, Method> unprocessedAccessors, EntityGraph graph, boolean forWriter) {
        block0: for (Map.Entry<String, Method> entry : unprocessedAccessors.entrySet()) {
            EntityProcessorContextImpl context = new EntityProcessorContextImpl(forWriter ? EntityProcessorContext.Type.METHOD_WRITER : EntityProcessorContext.Type.METHOD_READER, entry.getValue(), graph);
            for (EntityProcessor processor : this.entityProcessors) {
                EntityProcessor.Result result = processor.process(context);
                if (EntityProcessor.Result.ROLLBACK != result) continue;
                graph.remove(entry.getKey());
                continue block0;
            }
        }
    }
}

