/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.inject;

import javax.inject.Inject;
import javax.inject.Singleton;
import shaded.javax.ws.rs.BadRequestException;
import shaded.javax.ws.rs.container.ContainerRequestContext;
import shaded.javax.ws.rs.core.Request;
import shaded.javax.ws.rs.core.Response;
import shaded.org.glassfish.hk2.api.Factory;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.server.ContainerRequest;
import shaded.org.glassfish.jersey.server.internal.LocalizationMessages;
import shaded.org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import shaded.org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import shaded.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import shaded.org.glassfish.jersey.server.model.Parameter;

@Singleton
class EntityParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    EntityParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.ENTITY);
    }

    @Override
    protected Factory<?> createValueFactory(Parameter parameter) {
        return new EntityValueFactory(parameter);
    }

    private static class EntityValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final Parameter parameter;

        public EntityValueFactory(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Object provide() {
            ContainerRequest value;
            ContainerRequest requestContext = this.getContainerRequest();
            Class<?> rawType = this.parameter.getRawType();
            if ((Request.class.isAssignableFrom(rawType) || ContainerRequestContext.class.isAssignableFrom(rawType)) && rawType.isInstance(requestContext)) {
                value = requestContext;
            } else {
                value = requestContext.readEntity(rawType, this.parameter.getType(), this.parameter.getAnnotations());
                if (rawType.isPrimitive() && value == null) {
                    throw new BadRequestException(Response.status(Response.Status.BAD_REQUEST).entity(LocalizationMessages.ERROR_PRIMITIVE_TYPE_NULL()).build());
                }
            }
            return value;
        }
    }
}

