/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.outage;

import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.logging.Category;
import com.p6spy.engine.outage.InvocationInfo;
import com.p6spy.engine.outage.P6OutageOptions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public enum P6OutageDetector implements Runnable
{
    INSTANCE;

    private ConcurrentMap<Object, InvocationInfo> pendingMessages = new ConcurrentHashMap<Object, InvocationInfo>();
    private boolean haltThread;

    private P6OutageDetector() {
        ThreadGroup group = new ThreadGroup("P6SpyThreadGroup");
        group.setDaemon(true);
        Thread outageThread = new Thread(group, this, "P6SpyOutageThread");
        outageThread.start();
        P6LogQuery.debug("P6Spy - P6OutageDetector has been invoked.");
        P6LogQuery.debug("P6Spy - P6OutageOptions.getOutageDetectionIntervalMS() = " + P6OutageOptions.getActiveInstance().getOutageDetectionIntervalMS());
    }

    @Override
    public void run() {
        while (!this.haltThread) {
            this.detectOutage();
            try {
                Thread.sleep(P6OutageOptions.getActiveInstance().getOutageDetectionIntervalMS());
            }
            catch (Exception exception) {}
        }
    }

    public void shutdown() {
        this.haltThread = true;
    }

    public void registerInvocation(Object jdbcObject, long startTime, String category, String ps, String sql) {
        this.pendingMessages.put(jdbcObject, new InvocationInfo(startTime, category, ps, sql));
    }

    public void unregisterInvocation(Object jdbcObject) {
        this.pendingMessages.remove(jdbcObject);
    }

    private void detectOutage() {
        int listSize = this.pendingMessages.size();
        if (listSize == 0) {
            return;
        }
        P6LogQuery.debug("P6Spy - detectOutage.pendingMessage.size = " + listSize);
        long currentTime = System.nanoTime();
        long threshold = TimeUnit.MILLISECONDS.toNanos(P6OutageOptions.getActiveInstance().getOutageDetectionIntervalMS());
        for (Object jdbcObject : this.pendingMessages.keySet()) {
            InvocationInfo ii = (InvocationInfo)this.pendingMessages.get(jdbcObject);
            if (ii == null || currentTime - ii.startTime <= threshold) continue;
            P6LogQuery.debug("P6Spy - statement exceeded threshold - check log.");
            this.logOutage(ii);
        }
    }

    private void logOutage(InvocationInfo ii) {
        P6LogQuery.logElapsed(-1, System.nanoTime() - ii.startTime, Category.OUTAGE, ii.preparedStmt, ii.sql);
    }
}

