/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage;

import org.evomaster.client.java.instrumentation.Constants;
import org.evomaster.client.java.instrumentation.coverage.BranchCovMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.LineCovMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.MethodReplacementMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.SuccessCallMethodVisitor;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import shaded.org.objectweb.asm.ClassVisitor;
import shaded.org.objectweb.asm.MethodVisitor;

public class CoverageClassVisitor
extends ClassVisitor {
    private final String bytecodeClassName;

    public CoverageClassVisitor(ClassVisitor cv, ClassName className) {
        super(458752, cv);
        this.bytecodeClassName = className.getBytecodeName();
        UnitsInfoRecorder.markNewUnit(className.getFullNameWithDots());
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        if (Constants.isMethodSyntheticOrBridge(methodAccess)) {
            return mv;
        }
        if (name.equals("<clinit>")) {
            return mv;
        }
        ObjectiveRecorder.registerTarget(ObjectiveNaming.classObjectiveName(this.bytecodeClassName));
        mv = new LineCovMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new BranchCovMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new SuccessCallMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new MethodReplacementMethodVisitor(true, mv, this.bytecodeClassName, name, descriptor);
        return mv;
    }
}

