/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ObjectsClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Objects.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, replacingStatic=true)
    public static boolean equals(Object left, Object right, String idTemplate) {
        Truthness t;
        boolean result = Objects.equals(left, right);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.0);
        } else if (left == null || right == null) {
            t = new Truthness(0.05, 1.0);
        } else {
            double base = 0.1;
            double distance = DistanceHelper.getDistance(left, right);
            double h = base + (1.0 - base) / (1.0 + distance);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }
}

