/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.evomaster.client.java.controller.api.dto.ActionDto;
import org.evomaster.client.java.controller.api.dto.UnitsInfoDto;
import org.evomaster.client.java.controller.internal.SutController;
import org.evomaster.client.java.controller.internal.db.StandardOutputTracker;
import org.evomaster.client.java.instrumentation.Action;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.instrumentation.external.JarAgentLocator;
import org.evomaster.client.java.instrumentation.external.ServerController;
import org.evomaster.client.java.utils.SimpleLogger;

public abstract class ExternalSutController
extends SutController {
    public static final String PROP_MUTE_SUT = "em.muteSUT";
    protected volatile Process process;
    private volatile boolean instrumentation;
    private volatile Thread processKillHook;
    private volatile Thread outputPrinter;
    private volatile CountDownLatch latch;
    private volatile ServerController serverController;
    private volatile boolean initialized;
    private volatile StringBuffer errorBuffer;

    @Override
    public final void setupForGeneratedTest() {
    }

    public void setInstrumentation(boolean instrumentation) {
        this.instrumentation = instrumentation;
    }

    public abstract String[] getInputParameters();

    public abstract String[] getJVMParameters();

    public abstract String getBaseURL();

    public abstract String getPathToExecutableJar();

    public abstract String getLogMessageOfInitializedServer();

    public abstract long getMaxAwaitForInitializationInSeconds();

    public abstract void preStart();

    public abstract void postStart();

    public abstract void preStop();

    public abstract void postStop();

    @Override
    public String startSut() {
        boolean completed;
        boolean connected;
        String token;
        SimpleLogger.info("Going to start the SUT");
        this.initialized = false;
        this.validateJarPath();
        this.preStart();
        this.processKillHook = new Thread(() -> this.killProcess());
        Runtime.getRuntime().addShutdownHook(this.processKillHook);
        this.latch = new CountDownLatch(1);
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        if (this.instrumentation) {
            String jarPath;
            if (this.serverController == null) {
                this.serverController = new ServerController();
            }
            int port = this.serverController.startServer();
            command.add("-Devomaster.javaagent.external.port=" + port);
            String driver = this.getDatabaseDriverName();
            if (driver != null && !driver.isEmpty()) {
                command.add("-Devomaster.javaagent.sql.driver=" + driver);
            }
            if ((jarPath = JarAgentLocator.getAgentJarPath()) == null) {
                throw new IllegalStateException("Cannot locate JAR file with EvoMaster Java Agent");
            }
            command.add("-javaagent:" + jarPath + "=" + this.getPackagePrefixesToCover());
        }
        for (String s2 : this.getJVMParameters()) {
            if (s2 == null || (token = s2.trim()).isEmpty()) continue;
            command.add(token);
        }
        if (command.stream().noneMatch(s -> s.startsWith("-Xmx"))) {
            command.add("-Xmx2G");
        }
        if (command.stream().noneMatch(s -> s.startsWith("-Xms"))) {
            command.add("-Xms1G");
        }
        command.add("-jar");
        command.add(this.getPathToExecutableJar());
        for (String s2 : this.getInputParameters()) {
            if (s2 == null || (token = s2.trim()).isEmpty()) continue;
            command.add(token);
        }
        SimpleLogger.info("Going to start SUT with command:\n" + String.join((CharSequence)" ", command));
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        try {
            this.process = builder.start();
        }
        catch (IOException e) {
            SimpleLogger.error("Failed to start external process", e);
            return null;
        }
        this.startExternalProcessPrinter();
        if (this.instrumentation && this.serverController != null && !(connected = this.serverController.waitForIncomingConnection())) {
            SimpleLogger.error("Could not establish connection to retrieve code metrics");
            return null;
        }
        long timeout = this.getMaxAwaitForInitializationInSeconds();
        try {
            completed = this.latch.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            SimpleLogger.error("Interrupted controller");
            this.stopSut();
            return null;
        }
        if (!completed) {
            SimpleLogger.error("SUT has not started properly within " + timeout + " seconds");
            if (this.errorBuffer != null) {
                SimpleLogger.error("SUT output:\n" + this.errorBuffer.toString());
            }
            this.stopSut();
            return null;
        }
        if (!this.isSutRunning()) {
            SimpleLogger.error("SUT started but then terminated. Likely a possible misconfiguration");
            if (this.errorBuffer != null) {
                SimpleLogger.error("SUT output:\n" + this.errorBuffer.toString());
            }
            this.stopSut();
            return null;
        }
        if (!this.initialized) {
            SimpleLogger.error("SUT is started but not initialized");
            if (this.errorBuffer != null) {
                SimpleLogger.error("SUT output:\n" + this.errorBuffer.toString());
            }
            this.stopSut();
            return null;
        }
        this.postStart();
        return this.getBaseURL();
    }

    @Override
    public boolean isSutRunning() {
        return this.process != null && this.process.isAlive();
    }

    @Override
    public void stopSut() {
        SimpleLogger.info("Going to stop the SUT");
        this.preStop();
        if (this.serverController != null) {
            this.serverController.closeServer();
        }
        this.killProcess();
        this.initialized = false;
        this.postStop();
    }

    @Override
    public final boolean isInstrumentationActivated() {
        return this.instrumentation && this.serverController != null && this.serverController.isConnectionOn();
    }

    @Override
    public final void newSearch() {
        if (this.isInstrumentationActivated()) {
            this.serverController.resetForNewSearch();
        }
    }

    @Override
    public final void newTestSpecificHandler() {
        if (this.isInstrumentationActivated()) {
            this.serverController.resetForNewTest();
        }
    }

    @Override
    public final List<TargetInfo> getTargetInfos(Collection<Integer> ids) {
        this.checkInstrumentation();
        return this.serverController.getTargetsInfo(ids);
    }

    @Override
    public final List<AdditionalInfo> getAdditionalInfoList() {
        this.checkInstrumentation();
        return this.serverController.getAdditionalInfoList();
    }

    @Override
    public final void newActionSpecificHandler(ActionDto dto) {
        if (this.isInstrumentationActivated()) {
            this.serverController.setAction(new Action(dto.index, dto.inputVariables));
        }
    }

    @Override
    public final UnitsInfoDto getUnitsInfoDto() {
        if (!this.isInstrumentationActivated()) {
            return null;
        }
        return this.getUnitsInfoDto(this.serverController.getUnitsInfoRecorder());
    }

    private void checkInstrumentation() {
        if (!this.isInstrumentationActivated()) {
            throw new IllegalStateException("Instrumentation is not active");
        }
    }

    private void validateJarPath() {
        String path = this.getPathToExecutableJar();
        if (!path.endsWith(".jar")) {
            throw new IllegalStateException("Invalid jar path does not end with '.jar': " + path);
        }
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + path);
        }
    }

    private void killProcess() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.processKillHook);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.process != null) {
            try {
                this.process.getOutputStream().close();
                this.process.getInputStream().close();
                this.process.getErrorStream().close();
            }
            catch (Exception t) {
                SimpleLogger.error("Failed to close process stream: " + t.toString());
            }
            this.process.destroy();
            this.process = null;
        }
    }

    protected void startExternalProcessPrinter() {
        if (this.outputPrinter == null || !this.outputPrinter.isAlive()) {
            this.outputPrinter = new Thread(() -> {
                try {
                    boolean muted = Boolean.parseBoolean(System.getProperty(PROP_MUTE_SUT));
                    if (muted) {
                        this.errorBuffer = new StringBuffer(4096);
                    }
                    Scanner scanner = new Scanner(new BufferedReader(new InputStreamReader(this.process.getInputStream())));
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (line.startsWith("P6SPY_SQL: ")) {
                            StandardOutputTracker.handleSqlLine(this, line);
                        }
                        if (!muted) {
                            SimpleLogger.info("SUT: " + line);
                        } else if (this.errorBuffer != null) {
                            this.errorBuffer.append(line);
                            this.errorBuffer.append("\n");
                        }
                        if (!line.contains(this.getLogMessageOfInitializedServer())) continue;
                        this.initialized = true;
                        this.errorBuffer = null;
                        this.latch.countDown();
                    }
                    if (this.process == null || !this.process.isAlive()) {
                        SimpleLogger.warn("SUT has terminated");
                    } else {
                        SimpleLogger.warn("SUT is still alive, but its output was closed before producing the initialization message.");
                    }
                    this.latch.countDown();
                }
                catch (Exception e) {
                    SimpleLogger.error("Failed to handle external process printer", e);
                }
            });
            this.outputPrinter.start();
        }
    }
}

