/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db.constraint;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableCheckExpression;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableConstraint;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableUniqueConstraint;
import org.evomaster.client.java.controller.internal.db.constraint.TableConstraintExtractor;
import org.evomaster.client.java.utils.SimpleLogger;

public class H2ConstraintExtractor
extends TableConstraintExtractor {
    public static final String CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
    public static final String CHECK_EXPRESSION = "CHECK_EXPRESSION";
    public static final String COLUMN_LIST = "COLUMN_LIST";
    public static final String UNIQUE = "UNIQUE";
    public static final String REFERENTIAL = "REFERENTIAL";
    public static final String PRIMARY_KEY = "PRIMARY_KEY";
    public static final String PRIMARY_KEY_BLANK = "PRIMARY KEY";
    public static final String CHECK = "CHECK";

    @Override
    public List<DbTableConstraint> extract(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException {
        List<DbTableConstraint> columnConstraints = this.extractColumnConstraints(connectionToH2, schemaDto);
        List<DbTableConstraint> tableCheckExpressions = this.extractTableConstraints(connectionToH2, schemaDto);
        ArrayList<DbTableConstraint> allConstraints = new ArrayList<DbTableConstraint>();
        allConstraints.addAll(columnConstraints);
        allConstraints.addAll(tableCheckExpressions);
        return allConstraints;
    }

    private static void cannotHandle(String constraintType) {
        SimpleLogger.uniqueWarn("WARNING, EvoMaster cannot extract H2 constraints with type '" + constraintType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DbTableConstraint> extractTableConstraints(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException {
        ArrayList<DbTableConstraint> tableCheckExpressions = new ArrayList<DbTableConstraint>();
        String tableSchema = schemaDto.name;
        Iterator<TableDto> iterator = schemaDto.tables.iterator();
        block30: while (iterator.hasNext()) {
            TableDto tableDto = iterator.next();
            String tableName = tableDto.name;
            Statement statement = connectionToH2.createStatement();
            Throwable throwable = null;
            try {
                String query = String.format("Select * From INFORMATION_SCHEMA.CONSTRAINTS\n where CONSTRAINTS.TABLE_SCHEMA='%s' \n and CONSTRAINTS.TABLE_NAME='%s' ", tableSchema, tableName);
                ResultSet constraints = statement.executeQuery(query);
                Throwable throwable2 = null;
                try {
                    block31: while (true) {
                        if (!constraints.next()) continue block30;
                        String constraintType = constraints.getString(CONSTRAINT_TYPE);
                        String sqlCheckExpression = constraints.getString(CHECK_EXPRESSION);
                        String columnList = constraints.getString(COLUMN_LIST);
                        switch (constraintType) {
                            case "UNIQUE": {
                                List<String> uniqueColumnNames = Arrays.stream(columnList.split(",")).map(String::trim).collect(Collectors.toList());
                                DbTableConstraint constraint = new DbTableUniqueConstraint(tableName, uniqueColumnNames);
                                tableCheckExpressions.add(constraint);
                                continue block31;
                            }
                            case "PRIMARY_KEY": 
                            case "PRIMARY KEY": 
                            case "REFERENTIAL": {
                                continue block31;
                            }
                            case "CHECK": {
                                DbTableConstraint constraint = new DbTableCheckExpression(tableName, sqlCheckExpression);
                                tableCheckExpressions.add(constraint);
                                continue block31;
                            }
                        }
                        H2ConstraintExtractor.cannotHandle(constraintType);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (constraints == null) continue;
                    if (throwable2 != null) {
                        try {
                            constraints.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    constraints.close();
                    continue;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
                continue;
            }
            break;
        }
        return tableCheckExpressions;
    }

    private List<DbTableConstraint> extractColumnConstraints(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException {
        String tableSchema = schemaDto.name;
        ArrayList<DbTableConstraint> columnConstraints = new ArrayList<DbTableConstraint>();
        for (TableDto tableDto : schemaDto.tables) {
            String tableName = tableDto.name;
            Statement statement = connectionToH2.createStatement();
            Throwable throwable = null;
            try {
                String query = String.format("Select * From INFORMATION_SCHEMA.COLUMNS where COLUMNS.TABLE_SCHEMA='%s' and COLUMNS.TABLE_NAME='%s' ", tableSchema, tableName);
                ResultSet columns = statement.executeQuery(query);
                Throwable throwable2 = null;
                try {
                    while (columns.next()) {
                        String sqlCheckExpression = columns.getString("CHECK_CONSTRAINT");
                        if (sqlCheckExpression == null || sqlCheckExpression.equals("")) continue;
                        DbTableCheckExpression constraint = new DbTableCheckExpression(tableName, sqlCheckExpression);
                        columnConstraints.add(constraint);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (columns == null) continue;
                    if (throwable2 != null) {
                        try {
                            columns.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    columns.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
        return columnConstraints;
    }
}

