/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.util.Collection;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;

public abstract class CollectionsDistanceUtils {
    public static double getHeuristicToContains(Collection c, Object o) {
        Objects.requireNonNull(c);
        boolean result = c.contains(o);
        if (result) {
            return 1.0;
        }
        if (c.isEmpty()) {
            return 0.05;
        }
        double max = 0.05;
        for (Object value : c) {
            double distance = DistanceHelper.getDistance(o, value);
            double base = 0.1;
            double h = 0.1 + 0.9 / (1.0 + distance);
            if (!(h > max)) continue;
            max = h;
        }
        assert (max < 1.0);
        return max;
    }
}

