/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;

public class ObjectiveNaming {
    public static final String CLASS = "Class";
    public static final String LINE = "Line";
    public static final String BRANCH = "Branch";
    public static final String TRUE_BRANCH = "_trueBranch";
    public static final String FALSE_BRANCH = "_falseBranch";
    public static final String METHOD_REPLACEMENT = "MethodReplacement";
    public static final String SUCCESS_CALL = "Success_Call";
    public static final String NUMERIC_COMPARISON = "NumericComparison";

    public static String classObjectiveName(String className) {
        String name = "Class_" + ClassName.get(className).getFullNameWithDots();
        return name.intern();
    }

    public static String numericComparisonObjectiveName(String id, int res) {
        String name = "NumericComparison_" + id + "_" + (res == 0 ? "EQ" : (res < 0 ? "LT" : "GT"));
        return name.intern();
    }

    public static String lineObjectiveName(String className, int line) {
        String name = "Line_at_" + ClassName.get(className).getFullNameWithDots() + "_" + ObjectiveNaming.padNumber(line);
        return name.intern();
    }

    public static String successCallObjectiveName(String className, int line, int index) {
        String name = "Success_Call_at_" + ClassName.get(className).getFullNameWithDots() + "_" + ObjectiveNaming.padNumber(line) + "_" + index;
        return name.intern();
    }

    public static String methodReplacementObjectiveNameTemplate(String className, int line, int index) {
        String name = "MethodReplacement_at_" + ClassName.get(className).getFullNameWithDots() + "_" + ObjectiveNaming.padNumber(line) + "_" + index;
        return name.intern();
    }

    public static String methodReplacementObjectiveName(String template, boolean result, ReplacementType type) {
        if (template == null || !template.startsWith(METHOD_REPLACEMENT)) {
            throw new IllegalArgumentException("Invalid template for boolean method replacement: " + template);
        }
        String name = template + "_" + type.name() + "_" + result;
        return name.intern();
    }

    public static String branchObjectiveName(String className, int line, int branchId, boolean thenBranch) {
        String name = "Branch_at_" + ClassName.get(className).getFullNameWithDots() + "_at_line_" + ObjectiveNaming.padNumber(line) + "_position_" + branchId;
        name = thenBranch ? name + TRUE_BRANCH : name + FALSE_BRANCH;
        return name.intern();
    }

    private static String padNumber(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("Negative number to pad");
        }
        if (val < 10) {
            return "0000" + val;
        }
        if (val < 100) {
            return "000" + val;
        }
        if (val < 1000) {
            return "00" + val;
        }
        if (val < 10000) {
            return "0" + val;
        }
        return "" + val;
    }
}

