/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.deparser;

import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.util.deparser.LimitDeparser;
import shaded.net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class DeleteDeParser {
    protected StringBuilder buffer = new StringBuilder();
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();

    public DeleteDeParser() {
    }

    public DeleteDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(Delete delete) {
        this.buffer.append("DELETE");
        if (delete.getTables() != null && delete.getTables().size() > 0) {
            for (Table table : delete.getTables()) {
                this.buffer.append(" ").append(table.getFullyQualifiedName());
            }
        }
        this.buffer.append(" FROM ").append(delete.getTable().toString());
        if (delete.getJoins() != null) {
            for (Join join : delete.getJoins()) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        if (delete.getWhere() != null) {
            this.buffer.append(" WHERE ");
            delete.getWhere().accept(this.expressionVisitor);
        }
        if (delete.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(delete.getOrderByElements());
        }
        if (delete.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(delete.getLimit());
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

