/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.util.Collection;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;

public abstract class CollectionsDistanceUtils {
    public static double getHeuristicToContains(Collection c, Object o) {
        return CollectionsDistanceUtils.getHeuristicToContains(c, o, -1);
    }

    public static double getHeuristicToContains(Collection c, Object o, int limit) {
        Objects.requireNonNull(c);
        boolean result = c.contains(o);
        if (result) {
            return 1.0;
        }
        if (c.isEmpty()) {
            return 0.05;
        }
        if (o == null) {
            return 0.1;
        }
        int counter = 0;
        double base = 0.1;
        double max = 0.1;
        for (Object value : c) {
            double h;
            double distance;
            if (counter == limit) break;
            ++counter;
            if (value == null || (distance = DistanceHelper.getDistance(o, value)) == Double.MAX_VALUE || !((h = 0.1 + 0.9 / (1.0 + distance)) > max)) continue;
            max = h;
        }
        assert (max < 1.0);
        return max;
    }
}

