/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;

public class NumberParsingUtils {
    public static double getParsingHeuristicValueForFloat(String input) {
        if (input == null) {
            return 0.05;
        }
        if (input.length() == 0) {
            return 0.1;
        }
        long distance = 0L;
        if (input.length() == 1) {
            distance += (long)DistanceHelper.distanceToDigit(input.charAt(0));
        } else {
            for (int i = 0; i < input.length(); ++i) {
                int digitsDist = DistanceHelper.distanceToDigit(input.charAt(i));
                if (i == 0) {
                    distance += (long)Math.min(digitsDist, DistanceHelper.distanceToChar(input.charAt(i), '-'));
                    continue;
                }
                int firstIndexOfDot = input.substring(1).indexOf(46);
                if (firstIndexOfDot != -1) {
                    distance += (long)Math.min(digitsDist, DistanceHelper.distanceToChar(input.charAt(i), '.'));
                    continue;
                }
                if (i == firstIndexOfDot) {
                    distance += 0L;
                    continue;
                }
                distance += (long)digitsDist;
            }
        }
        double base = 0.1;
        return 0.1 + 0.9 / (double)(distance + 1L);
    }

    private static double parseIntHeuristic(String input, int maxNumberOfDigits) {
        if (maxNumberOfDigits < 0) {
            throw new IllegalArgumentException("Number of digits cannot be negative");
        }
        if (input == null) {
            return 0.05;
        }
        double base = 0.1;
        if (input.length() == 0) {
            return 0.1;
        }
        long distance = 0L;
        if (input.length() == 1) {
            distance += (long)DistanceHelper.distanceToDigit(input.charAt(0));
        } else {
            for (int i = 0; i < input.length(); ++i) {
                int digitsDist = DistanceHelper.distanceToDigit(input.charAt(i));
                if (i == 0) {
                    distance += (long)Math.min(digitsDist, DistanceHelper.distanceToChar(input.charAt(i), '-'));
                    continue;
                }
                if (i >= maxNumberOfDigits) {
                    distance += 65536L;
                    continue;
                }
                distance += (long)digitsDist;
            }
        }
        return 0.1 + 0.9 / (double)(distance + 1L);
    }

    public static double parseByteHeuristic(String input) {
        int maxNumberOfDigits = Byte.valueOf((byte)-128).toString().length();
        return NumberParsingUtils.parseIntHeuristic(input, maxNumberOfDigits);
    }

    public static double parseShortHeuristic(String input) {
        int maxNumberOfDigits = Short.valueOf((short)Short.MIN_VALUE).toString().length();
        return NumberParsingUtils.parseIntHeuristic(input, maxNumberOfDigits);
    }

    public static double parseIntHeuristic(String input) {
        int maxNumberOfDigits = Integer.valueOf(Integer.MIN_VALUE).toString().length();
        return NumberParsingUtils.parseIntHeuristic(input, maxNumberOfDigits);
    }

    public static double parseLongHeuristic(String input) {
        int maxNumberOfDigits = Long.valueOf(Long.MIN_VALUE).toString().length();
        return NumberParsingUtils.parseIntHeuristic(input, maxNumberOfDigits);
    }
}

