/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.heuristic;

import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;

public class TruthnessUtils {
    public static double normalizeValue(double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("Negative value: " + v);
        }
        if (Double.isInfinite(v) || v == Double.MAX_VALUE) {
            return 1.0;
        }
        double normalized = v / (v + 1.0);
        assert (normalized >= 0.0 && normalized <= 1.0);
        return normalized;
    }

    public static Truthness getEqualityTruthness(int a, int b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        double normalizedDistance = TruthnessUtils.normalizeValue(distance);
        return new Truthness(1.0 - normalizedDistance, a != b ? 1.0 : 0.0);
    }

    public static Truthness getEqualityTruthness(long a, long b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        double normalizedDistance = TruthnessUtils.normalizeValue(distance);
        return new Truthness(1.0 - normalizedDistance, a != b ? 1.0 : 0.0);
    }

    public static Truthness getLessThanTruthness(long a, long b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        return new Truthness(a < b ? 1.0 : 1.0 / (1.1 + distance), a >= b ? 1.0 : 1.0 / (1.1 + distance));
    }

    public static Truthness getEqualityTruthness(double a, double b) {
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        double normalizedDistance = TruthnessUtils.normalizeValue(distance);
        return new Truthness(1.0 - normalizedDistance, a != b ? 1.0 : 0.0);
    }

    public static Truthness getTruthnessToEmpty(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("lengths should always be non-negative. Invalid length " + len);
        }
        Truthness t = len == 0 ? new Truthness(1.0, 0.0) : new Truthness(1.0 / (1.0 + (double)len), 1.0);
        return t;
    }
}

