/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NumericConstraintBase;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.StringType;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class StringParam
extends NamedTypedValue<StringType, String>
implements NumericConstraintBase<BigDecimal> {
    private Integer minSize;
    private Integer maxSize;
    private BigDecimal min;
    private BigDecimal max;
    private String pattern;
    private boolean minInclusive = true;
    private boolean maxInclusive = true;
    private Integer precision;
    private Integer scale;

    public StringParam(String name, StringType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    public StringParam(String name, AccessibleSchema accessibleSchema) {
        super(name, new StringType(), accessibleSchema);
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        if (this.minSize != null && this.minSize >= minSize) {
            return;
        }
        this.minSize = minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = this.maxSize != null ? Integer.valueOf(Math.min(this.maxSize, maxSize)) : maxSize;
    }

    @Override
    public BigDecimal getMin() {
        return this.min;
    }

    @Override
    public void setMin(BigDecimal min) {
        if (min == null) {
            return;
        }
        if (this.min == null || this.min.compareTo(min) < 0) {
            this.min = min;
        }
    }

    @Override
    public BigDecimal getMax() {
        return this.max;
    }

    @Override
    public void setMax(BigDecimal max) {
        if (max == null) {
            return;
        }
        if (this.max == null || this.max.compareTo(max) > 0) {
            this.max = max;
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Object newInstance() {
        return this.getValue();
    }

    public StringParam copyStructure() {
        return new StringParam(this.getName(), (StringType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.stringValue != null) {
            this.setValue(dto.stringValue);
        }
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        assert (json instanceof String);
        this.setValue((String)json);
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.stringValue = (String)this.getValue();
        }
        if (this.maxSize != null) {
            dto.maxSize = (long)this.maxSize;
        }
        if (this.minSize != null) {
            dto.minSize = (long)this.minSize;
        }
        if (this.pattern != null) {
            dto.pattern = this.pattern;
        }
        this.handleConstraintsInCopyDto(dto);
        return dto;
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((String)instance);
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        String code;
        if (this.accessibleSchema == null || this.accessibleSchema.isAccessible) {
            code = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, ((StringType)this.getType()).getFullTypeName(), variableName, this.getValueAsJavaString());
        } else {
            if (this.accessibleSchema.setterMethodName == null) {
                throw new IllegalStateException("Error: private field, but there is no setter method");
            }
            code = CodeJavaGenerator.oneLineSetterInstance(this.accessibleSchema.setterMethodName, null, variableName, this.getValueAsJavaString());
        }
        return Collections.singletonList(CodeJavaGenerator.getIndent(indent) + code);
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaGenerator.junitAssertNull(responseVarName));
        } else {
            sb.append(CodeJavaGenerator.junitAssertEquals(this.getValueAsJavaString(), responseVarName));
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public String getValueAsJavaString() {
        return this.getValue() == null ? null : "\"" + CodeJavaGenerator.handleEscapeCharInString((String)this.getValue()) + "\"";
    }

    @Override
    public void copyProperties(NamedTypedValue copy) {
        super.copyProperties(copy);
        if (copy instanceof StringParam) {
            ((StringParam)copy).setMax(this.max);
            ((StringParam)copy).setMin(this.min);
            ((StringParam)copy).setMinSize(this.minSize);
            ((StringParam)copy).setMinSize(this.minSize);
            ((StringParam)copy).setPattern(this.pattern);
        }
        this.handleConstraintsInCopy(copy);
    }

    @Override
    public boolean getMinInclusive() {
        return this.minInclusive;
    }

    @Override
    public void setMinInclusive(boolean inclusive) {
        this.minInclusive = inclusive;
    }

    @Override
    public boolean getMaxInclusive() {
        return this.maxInclusive;
    }

    @Override
    public void setMaxInclusive(boolean inclusive) {
        this.maxInclusive = inclusive;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Integer scale) {
        this.scale = scale;
    }
}

