/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.ProtectionDomain;
import org.evomaster.client.java.instrumentation.ClassScanner;
import org.evomaster.client.java.instrumentation.ClassesToExclude;
import org.evomaster.client.java.instrumentation.Instrumentator;
import org.evomaster.client.java.instrumentation.external.AgentController;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.objectweb.asm.ClassReader;

public class InstrumentingAgent {
    private static Instrumentator instrumentator;
    private static String packagePrefixesToCover;
    private static boolean active;

    public static void premain(String args, Instrumentation inst) {
        InstrumentingAgent.agentmain(args, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        String outputFile;
        packagePrefixesToCover = agentArgs;
        instrumentator = new Instrumentator(packagePrefixesToCover);
        inst.addTransformer(new TransformerForTests());
        active = true;
        String port = System.getProperty("evomaster.javaagent.external.port");
        if (port != null) {
            SimpleLogger.info("Starting remote instrumenting Agent for packages: " + agentArgs);
            AgentController.start(Integer.parseInt(port));
        }
        if ((outputFile = System.getProperty("evomaster.javaagent.outputfile")) != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> InstrumentingAgent.saveCoverageToDisk(outputFile)));
        }
    }

    private static void saveCoverageToDisk(String outputFile) {
        try {
            SimpleLogger.info("Going to save coverage data to " + outputFile);
            ClassScanner.forceLoading(packagePrefixesToCover);
            Path path = Paths.get(outputFile, new String[0]);
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
            PrintWriter writer = new PrintWriter(outputFile, "UTF-8");
            ObjectiveRecorder.printCoveragePerTarget(writer);
            writer.close();
        }
        catch (IOException e) {
            SimpleLogger.error("Failed to save data to disk: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static void changePackagesToInstrument(String packagePrefixesToCover) {
        instrumentator = new Instrumentator(packagePrefixesToCover);
    }

    static {
        active = false;
    }

    private static class TransformerForTests
    implements ClassFileTransformer {
        private static final Method m;

        private TransformerForTests() {
        }

        private static boolean isAlreadyLoaded(ClassLoader loader, String classNameWithDots) {
            try {
                return m.invoke((Object)loader, classNameWithDots) != null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            ClassName cn = ClassName.get(className);
            if (!ClassesToExclude.checkIfCanInstrument(cn) || TransformerForTests.isAlreadyLoaded(loader, cn.getFullNameWithDots())) {
                return classfileBuffer;
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            byte[] instrumented = instrumentator.transformBytes(loader, cn, reader);
            if (instrumented == null) {
                return classfileBuffer;
            }
            return instrumented;
        }

        static {
            try {
                m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            m.setAccessible(true);
        }
    }
}

