/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Collection;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.CollectionsDistanceUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.heuristic.TruthnessUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class CollectionClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Collection.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean contains(Collection c, Object o, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(c);
        CollectionsDistanceUtils.evaluateTaint(c, o);
        boolean result = c.contains(o);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else {
            double h = CollectionsDistanceUtils.getHeuristicToContains(c, o);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.EXT_0)
    public static boolean containsAll(Collection caller, Collection other, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (other != null && !other.isEmpty()) {
            for (Object obj : other) {
                CollectionsDistanceUtils.evaluateTaint(caller, obj);
            }
        }
        boolean result = caller.containsAll(other);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else {
            double h = CollectionsDistanceUtils.getHeuristicToContainsAll(caller, other);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean isEmpty(Collection caller, String idTemplate) {
        Objects.requireNonNull(caller);
        boolean result = caller.isEmpty();
        if (idTemplate == null) {
            return result;
        }
        int len = caller.size();
        Truthness t = TruthnessUtils.getTruthnessToEmpty(len);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.EXT_0, isPure=false)
    public static boolean remove(Collection caller, Object obj, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        CollectionsDistanceUtils.evaluateTaint(caller, obj);
        boolean result = caller.remove(obj);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else {
            double h = CollectionsDistanceUtils.getHeuristicToContains(caller, obj);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.EXT_0, isPure=false)
    public static boolean removeAll(Collection caller, Collection other, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (other != null && !other.isEmpty()) {
            for (Object obj : other) {
                CollectionsDistanceUtils.evaluateTaint(caller, obj);
            }
        }
        boolean result = caller.removeAll(other);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else {
            double h = CollectionsDistanceUtils.getHeuristicToContainsAny(caller, other);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }
}

