/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.external;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Collection;
import org.evomaster.client.java.instrumentation.Action;
import org.evomaster.client.java.instrumentation.InstrumentationController;
import org.evomaster.client.java.instrumentation.external.Command;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;

public class AgentController {
    private static Socket socket;
    private static Thread thread;
    private static ObjectOutputStream out;
    private static ObjectInputStream in;

    public static void start(int port) {
        try {
            socket = new Socket("localhost", port);
            out = new ObjectOutputStream(socket.getOutputStream());
            in = new ObjectInputStream(socket.getInputStream());
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in Java Agent: " + e.getMessage(), e);
        }
        SimpleLogger.info("Connected to EvoMaster controller");
        thread = new Thread(() -> {
            while (!Thread.interrupted() && socket != null) {
                Object msg;
                try {
                    msg = in.readObject();
                }
                catch (IOException e) {
                    SimpleLogger.error("Failure in receiving message: " + e.getMessage());
                    return;
                }
                catch (ClassNotFoundException e) {
                    SimpleLogger.error("Configuration error: " + e.getMessage());
                    return;
                }
                if (msg == null || !(msg instanceof Command)) {
                    SimpleLogger.error("Received wrong message type: " + msg);
                    continue;
                }
                Command command = (Command)msg;
                long start = System.currentTimeMillis();
                SimpleLogger.debug("Handling command: " + command);
                switch (command) {
                    case NEW_SEARCH: {
                        InstrumentationController.resetForNewSearch();
                        AgentController.sendCommand(Command.ACK);
                        break;
                    }
                    case NEW_TEST: {
                        InstrumentationController.resetForNewTest();
                        AgentController.sendCommand(Command.ACK);
                        break;
                    }
                    case TARGETS_INFO: {
                        AgentController.handleTargetInfos();
                        break;
                    }
                    case ACTION_INDEX: {
                        AgentController.handleActionIndex();
                        AgentController.sendCommand(Command.ACK);
                        break;
                    }
                    case ADDITIONAL_INFO: {
                        AgentController.handleAdditionalInfo();
                        break;
                    }
                    case UNITS_INFO: {
                        AgentController.handleUnitsInfo();
                        break;
                    }
                    case KILL_SWITCH: {
                        AgentController.handleKillSwitch();
                        AgentController.sendCommand(Command.ACK);
                        break;
                    }
                    case EXECUTING_INIT_SQL: {
                        AgentController.handleExecutingInitSql();
                        AgentController.sendCommand(Command.ACK);
                        break;
                    }
                    case EXECUTING_ACTION: {
                        AgentController.handleExecutingAction();
                        AgentController.sendCommand(Command.ACK);
                        break;
                    }
                    case BOOT_TIME_INFO: {
                        AgentController.handleBootTimeObjectiveInfo();
                        break;
                    }
                    default: {
                        SimpleLogger.error("Unrecognized command: " + command);
                        return;
                    }
                }
                long delta = System.currentTimeMillis() - start;
                SimpleLogger.debug("Command took " + delta + " ms");
            }
        });
        thread.start();
    }

    private static void sendCommand(Command command) {
        try {
            AgentController.sendObject(command);
        }
        catch (Exception e) {
            SimpleLogger.error("Failure to send command " + command + ": " + e.getMessage());
        }
    }

    private static void handleUnitsInfo() {
        try {
            AgentController.sendObject(UnitsInfoRecorder.getInstance());
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in handling units info: " + e.getMessage());
        }
    }

    private static void handleActionIndex() {
        try {
            Object msg = in.readObject();
            Action action = (Action)msg;
            InstrumentationController.newAction(action);
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in handling action index: " + e.getMessage());
        }
    }

    private static void handleKillSwitch() {
        try {
            Object msg = in.readObject();
            Boolean killSwitch = (Boolean)msg;
            InstrumentationController.setKillSwitch(killSwitch);
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in handling kill-switch: " + e.getMessage());
        }
    }

    private static void handleExecutingInitSql() {
        try {
            Object msg = in.readObject();
            Boolean executingInitSql = (Boolean)msg;
            InstrumentationController.setExecutingInitSql(executingInitSql);
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in handling executing-init-sql: " + e.getMessage());
        }
    }

    private static void handleExecutingAction() {
        try {
            Object msg = in.readObject();
            Boolean executingAction = (Boolean)msg;
            InstrumentationController.setExecutingAction(executingAction);
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in handling executing-action: " + e.getMessage());
        }
    }

    private static void handleAdditionalInfo() {
        try {
            AgentController.sendObject(InstrumentationController.getAdditionalInfoList());
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in handling additional info: " + e.getMessage());
        }
    }

    private static void handleBootTimeObjectiveInfo() {
        try {
            AgentController.sendObject(InstrumentationController.getBootTimeObjectiveInfo());
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in handling Boot-time Objective Info: " + e.getMessage());
        }
    }

    private static void handleTargetInfos() {
        try {
            Object msg = in.readObject();
            Collection ids = (Collection)msg;
            AgentController.sendObject(InstrumentationController.getTargetInfos(ids));
        }
        catch (Exception e) {
            SimpleLogger.error("Failure in handling ids: " + e.getMessage());
        }
    }

    private static void sendObject(Object obj) throws IOException {
        try {
            out.writeObject(obj);
            out.reset();
        }
        catch (IOException e) {
            SimpleLogger.error("Failure in sending message: " + e.getMessage());
            throw e;
        }
    }
}

