/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;

public class MergeInsert {
    private List<Column> columns = null;
    private List<Expression> values = null;
    private Expression whereCondition;

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public void setValues(List<Expression> values) {
        this.values = values;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression whereCondition) {
        this.whereCondition = whereCondition;
    }

    public String toString() {
        return " WHEN NOT MATCHED THEN INSERT " + (this.columns.isEmpty() ? "" : PlainSelect.getStringList(this.columns, true, true)) + " VALUES " + PlainSelect.getStringList(this.values, true, true) + (this.whereCondition != null ? " WHERE " + this.whereCondition : "");
    }

    public MergeInsert withColumns(List<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public MergeInsert withValues(List<Expression> values) {
        this.setValues(values);
        return this;
    }

    public MergeInsert addColumns(Column ... columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columns);
        return this.withColumns(collection);
    }

    public MergeInsert addColumns(Collection<? extends Column> columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public MergeInsert addValues(Expression ... values) {
        List collection = Optional.ofNullable(this.getValues()).orElseGet(ArrayList::new);
        Collections.addAll(collection, values);
        return this.withValues(collection);
    }

    public MergeInsert addValues(Collection<? extends Expression> values) {
        List collection = Optional.ofNullable(this.getValues()).orElseGet(ArrayList::new);
        collection.addAll(values);
        return this.withValues(collection);
    }

    public MergeInsert withWhereCondition(Expression whereCondition) {
        this.setWhereCondition(whereCondition);
        return this;
    }

    public <E extends Expression> E getWhereCondition(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhereCondition()));
    }
}

