/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.validation.feature;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import shaded.net.sf.jsqlparser.parser.feature.Feature;
import shaded.net.sf.jsqlparser.util.validation.feature.DatabaseType;
import shaded.net.sf.jsqlparser.util.validation.feature.Version;

public enum SQLVersion implements Version
{
    SQL1986("SQL-86", EnumSet.of(Feature.jdbcParameter, new Feature[]{Feature.jdbcNamedParameter, Feature.select, Feature.selectGroupBy, Feature.function, Feature.insert, Feature.insertValues, Feature.update, Feature.delete, Feature.truncate, Feature.drop, Feature.alterTable})),
    SQL1989("SQL-89", SQL1986.copy().getFeatures()),
    SQL1992("SQL-92", SQL1989.copy().getFeatures()),
    SQL1999("SQL:1999", SQL1992.copy().add(Feature.exprSimilarTo).getFeatures()),
    SQL2003("SQL:2003", SQL1999.copy().getFeatures()),
    SQL2006("SQL:2006", SQL2003.copy().getFeatures()),
    SQL2008("SQL:2008", SQL2006.copy().getFeatures()),
    SQL2011("SQL:2011", SQL2008.copy().getFeatures()),
    SQL2016("SQL:2016", SQL2011.copy().getFeatures()),
    SQL2019("SQL:2019", SQL2016.copy().getFeatures());

    private Set<Feature> features;
    private String versionString;

    private SQLVersion(String versionString, Set<Feature> featuresSupported) {
        this(versionString, featuresSupported, Collections.emptySet());
    }

    private SQLVersion(String versionString, Set<Feature> featuresSupported, Set<Feature> unsupported) {
        this.versionString = versionString;
        this.features = featuresSupported;
        this.features.removeAll(unsupported);
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public Set<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public String getName() {
        return DatabaseType.SQLSERVER.getName() + " " + this.getVersionString();
    }
}

