/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.ByteBufferType;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class ByteBufferParam
extends NamedTypedValue<ByteBufferType, ByteBuffer> {
    public ByteBufferParam(String name, AccessibleSchema accessibleSchema) {
        super(name, new ByteBufferType(), accessibleSchema);
    }

    @Override
    public void setValue(byte[] value) {
        ByteBuffer buffer = ByteBuffer.allocate(value.length);
        buffer.put(value);
        this.setValue(buffer);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        return this.getValue();
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.stringValue = new String(((ByteBuffer)this.getValue()).array(), StandardCharsets.UTF_8);
        }
        return dto;
    }

    public ByteBufferParam copyStructure() {
        return new ByteBufferParam(this.getName(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.stringValue != null) {
            this.setValue(dto.stringValue.getBytes());
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((ByteBuffer)instance);
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        if (json == null) {
            return;
        }
        if (!(json instanceof String)) {
            throw new IllegalArgumentException("Cannot set value for ByteBufferParam with the type:" + json.getClass().getName());
        }
        this.setValue(((String)json).getBytes());
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        ArrayList<String> codes = new ArrayList<String>();
        String var = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, ByteBuffer.class.getName(), variableName, null);
        CodeJavaGenerator.addCode(codes, var, indent);
        if (this.getValue() == null) {
            return codes;
        }
        CodeJavaGenerator.addCode(codes, "{", indent);
        String varValue = variableName + "_byteArray";
        String byteArray = "\"" + new String(((ByteBuffer)this.getValue()).array(), StandardCharsets.UTF_8) + "\".getBytes(" + StandardCharsets.class.getName() + ".UTF_8)";
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.oneLineInstance(true, true, "byte[]", varValue, byteArray), indent + 1);
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.oneLineInstance(false, true, String.class.getName(), variableName, ByteBuffer.class.getName() + ".allocate(" + varValue + ".length)"), indent + 1);
        CodeJavaGenerator.addCode(codes, variableName + ".put(" + varValue + ");", indent + 1);
        CodeJavaGenerator.addCode(codes, "}", indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaGenerator.junitAssertNull(responseVarName));
        } else {
            sb.append("// not handle ByteBuffer assertion");
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public String getValueAsJavaString() {
        return null;
    }
}

