/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.IntParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.DateType;

public class DateParam
extends NamedTypedValue<DateType, List<IntParam>> {
    public DateParam(String name, DateType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    public DateParam(String name, AccessibleSchema accessibleSchema) {
        this(name, new DateType(), accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        return ((DateType)this.getType()).getDateInstance((List)this.getValue());
    }

    public DateParam copyStructure() {
        return new DateParam(this.getName(), (DateType)this.getType(), this.accessibleSchema);
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.innerContent = ((List)this.getValue()).stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
            dto.setNotNullValue();
        } else {
            dto.innerContent = ((DateType)this.getType()).getDateFields().stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        }
        return dto;
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.innerContent != null && !dto.innerContent.isEmpty()) {
            List<IntParam> fields = ((DateType)this.getType()).getDateFields();
            ArrayList<IntParam> values = new ArrayList<IntParam>();
            for (ParamDto p : dto.innerContent) {
                IntParam f = (IntParam)fields.stream().filter(s -> s.sameParam(p)).findFirst().get().copyStructureWithProperties();
                f.setValueBasedOnDto(p);
                values.add(f);
            }
            this.setValue(values);
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        if (instance == null) {
            return;
        }
        this.setValue(((DateType)this.getType()).getIntValues((Date)instance));
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        String typeName = ((DateType)this.getType()).getTypeNameForInstance();
        String varName = variableName;
        ArrayList<String> codes = new ArrayList<String>();
        boolean isNull = this.getValue() == null;
        String var = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, typeName, varName, null);
        CodeJavaGenerator.addCode(codes, var, indent);
        if (isNull) {
            return codes;
        }
        CodeJavaGenerator.addCode(codes, "{", indent);
        CodeJavaGenerator.addComment(codes, "Date is " + ((DateType)this.getType()).getDateString((List)this.getValue()), indent + 1);
        String time = ((DateType)this.getType()).getDateLong((List)this.getValue()) + "L";
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.setInstance(varName, CodeJavaGenerator.newObjectConsParams(typeName, time)), indent + 1);
        CodeJavaGenerator.addCode(codes, "}", indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaGenerator.junitAssertNull(responseVarName));
        } else {
            sb.append("// runtime value is ");
            sb.append(((DateType)this.getType()).getDateString((List)this.getValue()));
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public String getValueAsJavaString() {
        return null;
    }
}

