/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.utils.SimpleLogger;

public class ClassesToExclude {
    private static final Set<String> excludedClasses;
    private static final Set<String> includedClasses;
    private static final String EM_REPRESENTATIVE_CLASS = "org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer";
    private static final String EM_CLASS_LOAD_ERROR_MSG = "Fail to load org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer";

    private static List<String> getNotCommentedLines(InputStream excludedClassesStream) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(excludedClassesStream));){
            String line;
            while ((line = br.readLine()) != null) {
                String element = line.trim();
                if (element.startsWith("//") || element.isEmpty()) continue;
                list.add(element);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(list);
    }

    public static Set<String> getPackagePrefixesShouldNotBeInstrumented() {
        return excludedClasses;
    }

    private static boolean canLoadEMClass(ClassLoader loader) {
        try {
            loader.loadClass(EM_REPRESENTATIVE_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            SimpleLogger.uniqueWarn(EM_CLASS_LOAD_ERROR_MSG);
            return false;
        }
    }

    public static boolean checkIfCanInstrument(ClassLoader loader, ClassName cn) {
        if (loader != null && !ClassesToExclude.canLoadEMClass(loader)) {
            return false;
        }
        String className = cn.getFullNameWithDots();
        block0: for (String s : excludedClasses) {
            if (!className.startsWith(s)) continue;
            for (String k : includedClasses) {
                if (!className.startsWith(k)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    static {
        InputStream excludedClassesStream = ClassesToExclude.class.getClassLoader().getResourceAsStream("skipInstrumentationList.txt");
        HashSet<String> toSkip = new HashSet<String>(ClassesToExclude.getNotCommentedLines(excludedClassesStream));
        String custom = System.getProperty("em.skipClasses");
        if (custom != null && !custom.isEmpty()) {
            toSkip.addAll(Arrays.asList(custom.split(",")));
        }
        excludedClasses = Collections.unmodifiableSet(toSkip);
        InputStream includedClassesStream = ClassesToExclude.class.getClassLoader().getResourceAsStream("keepInstrumentationList.txt");
        includedClasses = Collections.unmodifiableSet(new HashSet<String>(ClassesToExclude.getNotCommentedLines(includedClassesStream)));
    }
}

