/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class JpaConstraint
implements Serializable {
    private final String tableName;
    private final String columnName;
    private final Boolean isNullable;
    private final Boolean isOptional;
    private final String minValue;
    private final String maxValue;
    private final List<String> enumValuesAsStrings;

    public JpaConstraint(String tableName, String columnName, Boolean isNullable, Boolean isOptional, String minValue, String maxValue, List<String> enumValuesAsStrings) {
        this.tableName = Objects.requireNonNull(tableName);
        this.columnName = Objects.requireNonNull(columnName);
        this.isNullable = isNullable;
        this.isOptional = isOptional;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.enumValuesAsStrings = enumValuesAsStrings;
    }

    public boolean isMeaningful() {
        return this.isNullable != null || this.isOptional != null || this.minValue != null || this.maxValue != null || this.enumValuesAsStrings != null && !this.enumValuesAsStrings.isEmpty();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Boolean getNullable() {
        return this.isNullable;
    }

    public Boolean getOptional() {
        return this.isOptional;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public List<String> getEnumValuesAsStrings() {
        return this.enumValuesAsStrings;
    }
}

