/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class CharacterClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Character.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean equals(Character caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof Character)) {
            t = new Truthness(0.05, 1.0);
        } else {
            Character anotherCharacter = (Character)anObject;
            if (caller.equals(anotherCharacter)) {
                t = new Truthness(1.0, 0.1);
            } else {
                double base = 0.1;
                double distance = DistanceHelper.getDistanceToEquality(caller.charValue(), anotherCharacter.charValue());
                double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }
}

